/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.metrics;

import java.util.regex.Pattern;

public final class IDs {
    private static final Pattern AZ09_LOWERCASE_REGEXP = Pattern.compile("[a-z][a-z0-9]*");
    private static final Pattern AZ09_REGEXP = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*");
    private static final Pattern AZ_09_REGEXP = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");
    private static final Pattern AZ09DOT_REGEXP = Pattern.compile("[a-zA-Z][a-zA-Z0-9\\.]*");

    private IDs() {
    }

    public static void checkOnlyLowercaseAZ09(String id) {
        IDs.check(id, AZ09_LOWERCASE_REGEXP);
    }

    public static void checkOnlyAZ09(String id) {
        IDs.check(id, AZ09_REGEXP);
    }

    public static void checkOnlyAZ09Underscore(String id) {
        IDs.check(id, AZ_09_REGEXP);
    }

    public static void checkOnlyAZ09Dot(String id) {
        IDs.check(id, AZ09DOT_REGEXP);
    }

    public static void check(String id, Pattern regexp) {
        if (!regexp.matcher(id).matches()) {
            throw new IllegalArgumentException("Invalid ID: \"" + id + "\" must match regular expression " + regexp.pattern());
        }
    }
}

