package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Tls} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Tls createTls(int fooXyzzy, int barBaz) {
 *         return new TlsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Tls, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Tls
 *
 */
@Generated("mdsal-binding-generator")
public class TlsBuilder {

    private String _certificatePassword;
    private List<String> _cipherSuites;
    private String _keystore;
    private String _keystorePassword;
    private PathType _keystorePathType;
    private KeystoreType _keystoreType;
    private String _truststore;
    private String _truststorePassword;
    private PathType _truststorePathType;
    private KeystoreType _truststoreType;


    Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TlsBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Tls}.
     *
     * @param base Tls from which the builder should be initialized
     */
    public TlsBuilder(Tls base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._certificatePassword = base.getCertificatePassword();
        this._cipherSuites = base.getCipherSuites();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
    }


    private static final class LazyEmpty {
        static final @NonNull Tls INSTANCE = new TlsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Tls.
     *
     * @return An empty {@link Tls}
     */
    public static @NonNull Tls empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Tls#getCertificatePassword()}.
     *
     * @return current value
     */
    public String getCertificatePassword() {
        return _certificatePassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getCipherSuites()}.
     *
     * @return current value
     */
    public List<String> getCipherSuites() {
        return _cipherSuites;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getKeystore()}.
     *
     * @return current value
     */
    public String getKeystore() {
        return _keystore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getKeystorePassword()}.
     *
     * @return current value
     */
    public String getKeystorePassword() {
        return _keystorePassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getKeystorePathType()}.
     *
     * @return current value
     */
    public PathType getKeystorePathType() {
        return _keystorePathType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getKeystoreType()}.
     *
     * @return current value
     */
    public KeystoreType getKeystoreType() {
        return _keystoreType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getTruststore()}.
     *
     * @return current value
     */
    public String getTruststore() {
        return _truststore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getTruststorePassword()}.
     *
     * @return current value
     */
    public String getTruststorePassword() {
        return _truststorePassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getTruststorePathType()}.
     *
     * @return current value
     */
    public PathType getTruststorePathType() {
        return _truststorePathType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tls#getTruststoreType()}.
     *
     * @return current value
     */
    public KeystoreType getTruststoreType() {
        return _truststoreType;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tls>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Tls#getCertificatePassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setCertificatePassword(final String value) {
        this._certificatePassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getCipherSuites()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public TlsBuilder setCipherSuites(final List<String> values) {
        this._cipherSuites = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Tls#getKeystore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setKeystore(final String value) {
        this._keystore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getKeystorePassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setKeystorePassword(final String value) {
        this._keystorePassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getKeystorePathType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setKeystorePathType(final PathType value) {
        this._keystorePathType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getKeystoreType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setKeystoreType(final KeystoreType value) {
        this._keystoreType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getTruststore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setTruststore(final String value) {
        this._truststore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getTruststorePassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setTruststorePassword(final String value) {
        this._truststorePassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getTruststorePathType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setTruststorePathType(final PathType value) {
        this._truststorePathType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tls#getTruststoreType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TlsBuilder setTruststoreType(final KeystoreType value) {
        this._truststoreType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TlsBuilder addAugmentation(Augmentation<Tls> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TlsBuilder removeAugmentation(Class<? extends Augmentation<Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Tls} instance.
     *
     * @return A new {@link Tls} instance.
     */
    public @NonNull Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl
        extends AbstractAugmentable<Tls>
        implements Tls {
    
        private final String _certificatePassword;
        private final List<String> _cipherSuites;
        private final String _keystore;
        private final String _keystorePassword;
        private final PathType _keystorePathType;
        private final KeystoreType _keystoreType;
        private final String _truststore;
        private final String _truststorePassword;
        private final PathType _truststorePathType;
        private final KeystoreType _truststoreType;
    
        TlsImpl(TlsBuilder base) {
            super(base.augmentation);
            this._certificatePassword = base.getCertificatePassword();
            this._cipherSuites = base.getCipherSuites();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
        }
    
        @Override
        public String getCertificatePassword() {
            return _certificatePassword;
        }
        
        @Override
        public List<String> getCipherSuites() {
            return _cipherSuites;
        }
        
        @Override
        public String getKeystore() {
            return _keystore;
        }
        
        @Override
        public String getKeystorePassword() {
            return _keystorePassword;
        }
        
        @Override
        public PathType getKeystorePathType() {
            return _keystorePathType;
        }
        
        @Override
        public KeystoreType getKeystoreType() {
            return _keystoreType;
        }
        
        @Override
        public String getTruststore() {
            return _truststore;
        }
        
        @Override
        public String getTruststorePassword() {
            return _truststorePassword;
        }
        
        @Override
        public PathType getTruststorePathType() {
            return _truststorePathType;
        }
        
        @Override
        public KeystoreType getTruststoreType() {
            return _truststoreType;
        }
    
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Tls.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Tls.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Tls.bindingToString(this);
        }
    }
}
