package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflow-switch-connection-config</b>
 * <pre>
 * container tls {
 *   leaf keystore {
 *     type string;
 *   }
 *   leaf keystore-type {
 *     type of-config:keystore-type;
 *   }
 *   leaf keystore-path-type {
 *     type of-config:path-type;
 *   }
 *   leaf keystore-password {
 *     type string;
 *   }
 *   leaf certificate-password {
 *     type string;
 *   }
 *   leaf truststore {
 *     type string;
 *   }
 *   leaf truststore-type {
 *     type of-config:keystore-type;
 *   }
 *   leaf truststore-path-type {
 *     type of-config:path-type;
 *   }
 *   leaf truststore-password {
 *     type string;
 *   }
 *   leaf-list cipher-suites {
 *     type string;
 *     ordered-by user;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link TlsBuilder}.
 * @see TlsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Tls
    extends
    ChildOf<SwitchConnectionConfig>,
    Augmentable<Tls>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tls");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Tls obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCertificatePassword());
        result = prime * result + Objects.hashCode(obj.getCipherSuites());
        result = prime * result + Objects.hashCode(obj.getKeystore());
        result = prime * result + Objects.hashCode(obj.getKeystorePassword());
        result = prime * result + Objects.hashCode(obj.getKeystorePathType());
        result = prime * result + Objects.hashCode(obj.getKeystoreType());
        result = prime * result + Objects.hashCode(obj.getTruststore());
        result = prime * result + Objects.hashCode(obj.getTruststorePassword());
        result = prime * result + Objects.hashCode(obj.getTruststorePathType());
        result = prime * result + Objects.hashCode(obj.getTruststoreType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Tls thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls.class, obj);
        return other != null
            && Objects.equals(thisObj.getCertificatePassword(), other.getCertificatePassword())
            && Objects.equals(thisObj.getKeystore(), other.getKeystore())
            && Objects.equals(thisObj.getKeystorePassword(), other.getKeystorePassword())
            && Objects.equals(thisObj.getTruststore(), other.getTruststore())
            && Objects.equals(thisObj.getTruststorePassword(), other.getTruststorePassword())
            && Objects.equals(thisObj.getCipherSuites(), other.getCipherSuites())
            && Objects.equals(thisObj.getKeystorePathType(), other.getKeystorePathType())
            && Objects.equals(thisObj.getKeystoreType(), other.getKeystoreType())
            && Objects.equals(thisObj.getTruststorePathType(), other.getTruststorePathType())
            && Objects.equals(thisObj.getTruststoreType(), other.getTruststoreType())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Tls obj) {
        final var helper = MoreObjects.toStringHelper("Tls");
        CodeHelpers.appendValue(helper, "certificatePassword", obj.getCertificatePassword());
        CodeHelpers.appendValue(helper, "cipherSuites", obj.getCipherSuites());
        CodeHelpers.appendValue(helper, "keystore", obj.getKeystore());
        CodeHelpers.appendValue(helper, "keystorePassword", obj.getKeystorePassword());
        CodeHelpers.appendValue(helper, "keystorePathType", obj.getKeystorePathType());
        CodeHelpers.appendValue(helper, "keystoreType", obj.getKeystoreType());
        CodeHelpers.appendValue(helper, "truststore", obj.getTruststore());
        CodeHelpers.appendValue(helper, "truststorePassword", obj.getTruststorePassword());
        CodeHelpers.appendValue(helper, "truststorePathType", obj.getTruststorePathType());
        CodeHelpers.appendValue(helper, "truststoreType", obj.getTruststoreType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return keystore, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore location
     *     </code>
     * </pre>
     *
     * @return {@code String} keystore, or {@code null} if it is not present.
     *
     */
    String getKeystore();
    
    /**
     * Return keystore, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore location
     *     </code>
     * </pre>
     *
     * @return {@code String} keystore, guaranteed to be non-null.
     * @throws NoSuchElementException if keystore is not present
     *
     */
    default @NonNull String requireKeystore() {
        return CodeHelpers.require(getKeystore(), "keystore");
    }
    
    /**
     * Return keystoreType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code KeystoreType} keystoreType, or {@code null} if it is not present.
     *
     */
    KeystoreType getKeystoreType();
    
    /**
     * Return keystoreType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code KeystoreType} keystoreType, guaranteed to be non-null.
     * @throws NoSuchElementException if keystoreType is not present
     *
     */
    default @NonNull KeystoreType requireKeystoreType() {
        return CodeHelpers.require(getKeystoreType(), "keystoretype");
    }
    
    /**
     * Return keystorePathType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} keystorePathType, or {@code null} if it is not present.
     *
     */
    PathType getKeystorePathType();
    
    /**
     * Return keystorePathType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} keystorePathType, guaranteed to be non-null.
     * @throws NoSuchElementException if keystorePathType is not present
     *
     */
    default @NonNull PathType requireKeystorePathType() {
        return CodeHelpers.require(getKeystorePathType(), "keystorepathtype");
    }
    
    /**
     * Return keystorePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting keystore
     *     </code>
     * </pre>
     *
     * @return {@code String} keystorePassword, or {@code null} if it is not present.
     *
     */
    String getKeystorePassword();
    
    /**
     * Return keystorePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting keystore
     *     </code>
     * </pre>
     *
     * @return {@code String} keystorePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if keystorePassword is not present
     *
     */
    default @NonNull String requireKeystorePassword() {
        return CodeHelpers.require(getKeystorePassword(), "keystorepassword");
    }
    
    /**
     * Return certificatePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} certificatePassword, or {@code null} if it is not present.
     *
     */
    String getCertificatePassword();
    
    /**
     * Return certificatePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} certificatePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if certificatePassword is not present
     *
     */
    default @NonNull String requireCertificatePassword() {
        return CodeHelpers.require(getCertificatePassword(), "certificatepassword");
    }
    
    /**
     * Return truststore, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore location
     *     </code>
     * </pre>
     *
     * @return {@code String} truststore, or {@code null} if it is not present.
     *
     */
    String getTruststore();
    
    /**
     * Return truststore, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore location
     *     </code>
     * </pre>
     *
     * @return {@code String} truststore, guaranteed to be non-null.
     * @throws NoSuchElementException if truststore is not present
     *
     */
    default @NonNull String requireTruststore() {
        return CodeHelpers.require(getTruststore(), "truststore");
    }
    
    /**
     * Return truststoreType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code KeystoreType} truststoreType, or {@code null} if it is not present.
     *
     */
    KeystoreType getTruststoreType();
    
    /**
     * Return truststoreType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code KeystoreType} truststoreType, guaranteed to be non-null.
     * @throws NoSuchElementException if truststoreType is not present
     *
     */
    default @NonNull KeystoreType requireTruststoreType() {
        return CodeHelpers.require(getTruststoreType(), "truststoretype");
    }
    
    /**
     * Return truststorePathType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} truststorePathType, or {@code null} if it is not present.
     *
     */
    PathType getTruststorePathType();
    
    /**
     * Return truststorePathType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} truststorePathType, guaranteed to be non-null.
     * @throws NoSuchElementException if truststorePathType is not present
     *
     */
    default @NonNull PathType requireTruststorePathType() {
        return CodeHelpers.require(getTruststorePathType(), "truststorepathtype");
    }
    
    /**
     * Return truststorePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting truststore
     *     </code>
     * </pre>
     *
     * @return {@code String} truststorePassword, or {@code null} if it is not present.
     *
     */
    String getTruststorePassword();
    
    /**
     * Return truststorePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting truststore
     *     </code>
     * </pre>
     *
     * @return {@code String} truststorePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if truststorePassword is not present
     *
     */
    default @NonNull String requireTruststorePassword() {
        return CodeHelpers.require(getTruststorePassword(), "truststorepassword");
    }
    
    /**
     * Return cipherSuites, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         combination of cryptographic algorithms used by TLS connection
     *     </code>
     * </pre>
     *
     * @return {@code List<String>} cipherSuites, or {@code null} if it is not present.
     *
     */
    @Nullable List<String> getCipherSuites();
    
    /**
     * Return cipherSuites, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         combination of cryptographic algorithms used by TLS connection
     *     </code>
     * </pre>
     *
     * @return {@code List<String>} cipherSuites, guaranteed to be non-null.
     * @throws NoSuchElementException if cipherSuites is not present
     *
     */
    default @NonNull List<String> requireCipherSuites() {
        return CodeHelpers.require(getCipherSuites(), "ciphersuites");
    }

}

