package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link Threads} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Threads createThreads(int fooXyzzy, int barBaz) {
 *         return new ThreadsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Threads, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Threads
 *
 */
@Generated("mdsal-binding-generator")
public class ThreadsBuilder {

    private Uint16 _bossThreads;
    private Uint16 _workerThreads;


    Map<Class<? extends Augmentation<Threads>>, Augmentation<Threads>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ThreadsBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Threads}.
     *
     * @param base Threads from which the builder should be initialized
     */
    public ThreadsBuilder(Threads base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bossThreads = base.getBossThreads();
        this._workerThreads = base.getWorkerThreads();
    }


    private static final class LazyEmpty {
        static final @NonNull Threads INSTANCE = new ThreadsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Threads.
     *
     * @return An empty {@link Threads}
     */
    public static @NonNull Threads empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Threads#getBossThreads()}.
     *
     * @return current value
     */
    public Uint16 getBossThreads() {
        return _bossThreads;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Threads#getWorkerThreads()}.
     *
     * @return current value
     */
    public Uint16 getWorkerThreads() {
        return _workerThreads;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Threads>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Threads#getBossThreads()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ThreadsBuilder setBossThreads(final Uint16 value) {
        this._bossThreads = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Threads#getWorkerThreads()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ThreadsBuilder setWorkerThreads(final Uint16 value) {
        this._workerThreads = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ThreadsBuilder addAugmentation(Augmentation<Threads> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ThreadsBuilder removeAugmentation(Class<? extends Augmentation<Threads>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Threads} instance.
     *
     * @return A new {@link Threads} instance.
     */
    public @NonNull Threads build() {
        return new ThreadsImpl(this);
    }

    private static final class ThreadsImpl
        extends AbstractAugmentable<Threads>
        implements Threads {
    
        private final Uint16 _bossThreads;
        private final Uint16 _workerThreads;
    
        ThreadsImpl(ThreadsBuilder base) {
            super(base.augmentation);
            this._bossThreads = base.getBossThreads();
            this._workerThreads = base.getWorkerThreads();
        }
    
        @Override
        public Uint16 getBossThreads() {
            return _bossThreads;
        }
        
        @Override
        public Uint16 getWorkerThreads() {
            return _workerThreads;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Threads.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Threads.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Threads.bindingToString(this);
        }
    }
}
