package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflow-switch-connection-config</b>
 * <pre>
 * container threads {
 *   leaf boss-threads {
 *     type uint16;
 *   }
 *   leaf worker-threads {
 *     type uint16;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ThreadsBuilder}.
 * @see ThreadsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Threads
    extends
    ChildOf<SwitchConnectionConfig>,
    Augmentable<Threads>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("threads");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Threads obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBossThreads());
        result = prime * result + Objects.hashCode(obj.getWorkerThreads());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Threads thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads.class, obj);
        return other != null
            && Objects.equals(thisObj.getBossThreads(), other.getBossThreads())
            && Objects.equals(thisObj.getWorkerThreads(), other.getWorkerThreads())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.@NonNull Threads obj) {
        final var helper = MoreObjects.toStringHelper("Threads");
        CodeHelpers.appendValue(helper, "bossThreads", obj.getBossThreads());
        CodeHelpers.appendValue(helper, "workerThreads", obj.getWorkerThreads());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return bossThreads, or {@code null} if it is not present.
     *
     * @return {@code Uint16} bossThreads, or {@code null} if it is not present.
     *
     */
    Uint16 getBossThreads();
    
    /**
     * Return bossThreads, guaranteed to be non-null.
     *
     * @return {@code Uint16} bossThreads, guaranteed to be non-null.
     * @throws NoSuchElementException if bossThreads is not present
     *
     */
    default @NonNull Uint16 requireBossThreads() {
        return CodeHelpers.require(getBossThreads(), "bossthreads");
    }
    
    /**
     * Return workerThreads, or {@code null} if it is not present.
     *
     * @return {@code Uint16} workerThreads, or {@code null} if it is not present.
     *
     */
    Uint16 getWorkerThreads();
    
    /**
     * Return workerThreads, guaranteed to be non-null.
     *
     * @return {@code Uint16} workerThreads, guaranteed to be non-null.
     * @throws NoSuchElementException if workerThreads is not present
     *
     */
    default @NonNull Uint16 requireWorkerThreads() {
        return CodeHelpers.require(getWorkerThreads(), "workerthreads");
    }

}

