package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link SwitchConnectionConfig} class.
 *
 * @see SwitchConnectionConfig
 *
 */
@Generated("mdsal-binding-generator")
public class SwitchConnectionConfigKey
 implements Key<SwitchConnectionConfig> {
    @java.io.Serial
    private static final long serialVersionUID = 6085058115728706996L;
    private final String _instanceName;


    /**
     * Constructs an instance.
     *
     * @param _instanceName the entity instanceName
     * @throws NullPointerException if any of the arguments are null
     */
    public SwitchConnectionConfigKey(@NonNull String _instanceName) {
        this._instanceName = CodeHelpers.requireKeyProp(_instanceName, "instanceName");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public SwitchConnectionConfigKey(SwitchConnectionConfigKey source) {
        this._instanceName = source._instanceName;
    }


    /**
     * Return instanceName, guaranteed to be non-null.
     *
     * @return {@code String} instanceName, guaranteed to be non-null.
     */
    public @NonNull String getInstanceName() {
        return _instanceName;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_instanceName);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof SwitchConnectionConfigKey other
            && Objects.equals(_instanceName, other._instanceName);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(SwitchConnectionConfigKey.class);
        CodeHelpers.appendValue(helper, "instanceName", _instanceName);
        return helper.toString();
    }
}

