package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link SwitchConnectionConfig} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SwitchConnectionConfig createSwitchConnectionConfig(int fooXyzzy, int barBaz) {
 *         return new SwitchConnectionConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SwitchConnectionConfig, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SwitchConnectionConfig
 *
 */
@Generated("mdsal-binding-generator")
public class SwitchConnectionConfigBuilder {

    private IpAddress _address;
    private Uint16 _channelOutboundQueueSize;
    private Boolean _groupAddModEnabled;
    private String _instanceName;
    private Uint16 _port;
    private Uint32 _switchIdleTimeout;
    private Threads _threads;
    private Tls _tls;
    private TransportProtocol _transportProtocol;
    private Boolean _useBarrier;
    private SwitchConnectionConfigKey key;


    Map<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SwitchConnectionConfigBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link SwitchConnectionConfig}.
     *
     * @param base SwitchConnectionConfig from which the builder should be initialized
     */
    public SwitchConnectionConfigBuilder(SwitchConnectionConfig base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._instanceName = base.getInstanceName();
        this._address = base.getAddress();
        this._channelOutboundQueueSize = base.getChannelOutboundQueueSize();
        this._groupAddModEnabled = base.getGroupAddModEnabled();
        this._port = base.getPort();
        this._switchIdleTimeout = base.getSwitchIdleTimeout();
        this._threads = base.getThreads();
        this._tls = base.getTls();
        this._transportProtocol = base.getTransportProtocol();
        this._useBarrier = base.getUseBarrier();
    }



    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#key()}.
     *
     * @return current value
     */
    public SwitchConnectionConfigKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getAddress()}.
     *
     * @return current value
     */
    public IpAddress getAddress() {
        return _address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getChannelOutboundQueueSize()}.
     *
     * @return current value
     */
    public Uint16 getChannelOutboundQueueSize() {
        return _channelOutboundQueueSize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getGroupAddModEnabled()}.
     *
     * @return current value
     */
    public Boolean getGroupAddModEnabled() {
        return _groupAddModEnabled;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getInstanceName()}.
     *
     * @return current value
     */
    public String getInstanceName() {
        return _instanceName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getPort()}.
     *
     * @return current value
     */
    public Uint16 getPort() {
        return _port;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getSwitchIdleTimeout()}.
     *
     * @return current value
     */
    public Uint32 getSwitchIdleTimeout() {
        return _switchIdleTimeout;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getThreads()}.
     *
     * @return current value
     */
    public Threads getThreads() {
        return _threads;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getTls()}.
     *
     * @return current value
     */
    public Tls getTls() {
        return _tls;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getTransportProtocol()}.
     *
     * @return current value
     */
    public TransportProtocol getTransportProtocol() {
        return _transportProtocol;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SwitchConnectionConfig#getUseBarrier()}.
     *
     * @return current value
     */
    public Boolean getUseBarrier() {
        return _useBarrier;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SwitchConnectionConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link SwitchConnectionConfig#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder withKey(final SwitchConnectionConfigKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getChannelOutboundQueueSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setChannelOutboundQueueSize(final Uint16 value) {
        this._channelOutboundQueueSize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getGroupAddModEnabled()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setGroupAddModEnabled(final Boolean value) {
        this._groupAddModEnabled = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getInstanceName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setInstanceName(final String value) {
        this._instanceName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getPort()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setPort(final Uint16 value) {
        this._port = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getSwitchIdleTimeout()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setSwitchIdleTimeout(final Uint32 value) {
        this._switchIdleTimeout = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getThreads()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setThreads(final Threads value) {
        this._threads = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getTls()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setTls(final Tls value) {
        this._tls = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getTransportProtocol()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setTransportProtocol(final TransportProtocol value) {
        this._transportProtocol = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SwitchConnectionConfig#getUseBarrier()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SwitchConnectionConfigBuilder setUseBarrier(final Boolean value) {
        this._useBarrier = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SwitchConnectionConfigBuilder addAugmentation(Augmentation<SwitchConnectionConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SwitchConnectionConfigBuilder removeAugmentation(Class<? extends Augmentation<SwitchConnectionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SwitchConnectionConfig} instance.
     *
     * @return A new {@link SwitchConnectionConfig} instance.
     */
    public @NonNull SwitchConnectionConfig build() {
        return new SwitchConnectionConfigImpl(this);
    }

    private static final class SwitchConnectionConfigImpl
        extends AbstractAugmentable<SwitchConnectionConfig>
        implements SwitchConnectionConfig {
    
        private final IpAddress _address;
        private final Uint16 _channelOutboundQueueSize;
        private final Boolean _groupAddModEnabled;
        private final String _instanceName;
        private final Uint16 _port;
        private final Uint32 _switchIdleTimeout;
        private final Threads _threads;
        private final Tls _tls;
        private final TransportProtocol _transportProtocol;
        private final Boolean _useBarrier;
        private final SwitchConnectionConfigKey key;
    
        SwitchConnectionConfigImpl(SwitchConnectionConfigBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new SwitchConnectionConfigKey(base.getInstanceName());
            }
            this._instanceName = key.getInstanceName();
            this._address = base.getAddress();
            this._channelOutboundQueueSize = base.getChannelOutboundQueueSize();
            this._groupAddModEnabled = base.getGroupAddModEnabled();
            this._port = base.getPort();
            this._switchIdleTimeout = base.getSwitchIdleTimeout();
            this._threads = base.getThreads();
            this._tls = base.getTls();
            this._transportProtocol = base.getTransportProtocol();
            this._useBarrier = base.getUseBarrier();
        }
    
        @Override
        public SwitchConnectionConfigKey key() {
            return key;
        }
        
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public Uint16 getChannelOutboundQueueSize() {
            return _channelOutboundQueueSize;
        }
        
        @Override
        public Boolean getGroupAddModEnabled() {
            return _groupAddModEnabled;
        }
        
        @Override
        public String getInstanceName() {
            return _instanceName;
        }
        
        @Override
        public Uint16 getPort() {
            return _port;
        }
        
        @Override
        public Uint32 getSwitchIdleTimeout() {
            return _switchIdleTimeout;
        }
        
        @Override
        public Threads getThreads() {
            return _threads;
        }
        
        @Override
        public Tls getTls() {
            return _tls;
        }
        
        @Override
        public TransportProtocol getTransportProtocol() {
            return _transportProtocol;
        }
        
        @Override
        public Boolean getUseBarrier() {
            return _useBarrier;
        }
    
        
        
        
        
        
        
        @Override
        public Threads nonnullThreads() {
            return Objects.requireNonNullElse(getThreads(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.ThreadsBuilder.empty());
        }
        
        @Override
        public Tls nonnullTls() {
            return Objects.requireNonNullElse(getTls(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.TlsBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SwitchConnectionConfig.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SwitchConnectionConfig.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SwitchConnectionConfig.bindingToString(this);
        }
    }
}
