package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflow-switch-connection-config</b>
 * <pre>
 * list switch-connection-config {
 *   key instance-name;
 *   leaf instance-name {
 *     type string;
 *   }
 *   leaf port {
 *     type uint16;
 *   }
 *   leaf transport-protocol {
 *     type of-config:transport-protocol;
 *   }
 *   leaf channel-outbound-queue-size {
 *     type uint16;
 *     default 1024;
 *   }
 *   leaf address {
 *     type ietf-inet:ip-address;
 *   }
 *   leaf use-barrier {
 *     type boolean;
 *     default true;
 *   }
 *   leaf group-add-mod-enabled {
 *     type boolean;
 *     default false;
 *   }
 *   leaf switch-idle-timeout {
 *     type uint32;
 *     default 15000;
 *   }
 *   container tls {
 *     leaf keystore {
 *       type string;
 *     }
 *     leaf keystore-type {
 *       type of-config:keystore-type;
 *     }
 *     leaf keystore-path-type {
 *       type of-config:path-type;
 *     }
 *     leaf keystore-password {
 *       type string;
 *     }
 *     leaf certificate-password {
 *       type string;
 *     }
 *     leaf truststore {
 *       type string;
 *     }
 *     leaf truststore-type {
 *       type of-config:keystore-type;
 *     }
 *     leaf truststore-path-type {
 *       type of-config:path-type;
 *     }
 *     leaf truststore-password {
 *       type string;
 *     }
 *     leaf-list cipher-suites {
 *       type string;
 *       ordered-by user;
 *     }
 *   }
 *   container threads {
 *     leaf boss-threads {
 *       type uint16;
 *     }
 *     leaf worker-threads {
 *       type uint16;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SwitchConnectionConfigBuilder}.
 * @see SwitchConnectionConfigBuilder
 * @see SwitchConnectionConfigKey
 *
 */
@Generated("mdsal-binding-generator")
public interface SwitchConnectionConfig
    extends
    ChildOf<OpenflowSwitchConnectionConfigData>,
    Augmentable<SwitchConnectionConfig>,
    KeyAware<SwitchConnectionConfigKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("switch-connection-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.@NonNull SwitchConnectionConfig obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getChannelOutboundQueueSize());
        result = prime * result + Objects.hashCode(obj.getGroupAddModEnabled());
        result = prime * result + Objects.hashCode(obj.getInstanceName());
        result = prime * result + Objects.hashCode(obj.getPort());
        result = prime * result + Objects.hashCode(obj.getSwitchIdleTimeout());
        result = prime * result + Objects.hashCode(obj.getThreads());
        result = prime * result + Objects.hashCode(obj.getTls());
        result = prime * result + Objects.hashCode(obj.getTransportProtocol());
        result = prime * result + Objects.hashCode(obj.getUseBarrier());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.@NonNull SwitchConnectionConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig.class, obj);
        return other != null
            && Objects.equals(thisObj.getChannelOutboundQueueSize(), other.getChannelOutboundQueueSize())
            && Objects.equals(thisObj.getGroupAddModEnabled(), other.getGroupAddModEnabled())
            && Objects.equals(thisObj.getPort(), other.getPort())
            && Objects.equals(thisObj.getSwitchIdleTimeout(), other.getSwitchIdleTimeout())
            && Objects.equals(thisObj.getUseBarrier(), other.getUseBarrier())
            && Objects.equals(thisObj.getInstanceName(), other.getInstanceName())
            && Objects.equals(thisObj.getAddress(), other.getAddress())
            && Objects.equals(thisObj.getThreads(), other.getThreads())
            && Objects.equals(thisObj.getTls(), other.getTls())
            && Objects.equals(thisObj.getTransportProtocol(), other.getTransportProtocol())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.@NonNull SwitchConnectionConfig obj) {
        final var helper = MoreObjects.toStringHelper("SwitchConnectionConfig");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "channelOutboundQueueSize", obj.getChannelOutboundQueueSize());
        CodeHelpers.appendValue(helper, "groupAddModEnabled", obj.getGroupAddModEnabled());
        CodeHelpers.appendValue(helper, "instanceName", obj.getInstanceName());
        CodeHelpers.appendValue(helper, "port", obj.getPort());
        CodeHelpers.appendValue(helper, "switchIdleTimeout", obj.getSwitchIdleTimeout());
        CodeHelpers.appendValue(helper, "threads", obj.getThreads());
        CodeHelpers.appendValue(helper, "tls", obj.getTls());
        CodeHelpers.appendValue(helper, "transportProtocol", obj.getTransportProtocol());
        CodeHelpers.appendValue(helper, "useBarrier", obj.getUseBarrier());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    SwitchConnectionConfigKey key();
    
    /**
     * Return instanceName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the switch connection instance.
     *     </code>
     * </pre>
     *
     * @return {@code String} instanceName, or {@code null} if it is not present.
     *
     */
    String getInstanceName();
    
    /**
     * Return instanceName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the switch connection instance.
     *     </code>
     * </pre>
     *
     * @return {@code String} instanceName, guaranteed to be non-null.
     * @throws NoSuchElementException if instanceName is not present
     *
     */
    default @NonNull String requireInstanceName() {
        return CodeHelpers.require(getInstanceName(), "instancename");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         local listening port
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} port, or {@code null} if it is not present.
     *
     */
    Uint16 getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         local listening port
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull Uint16 requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }
    
    /**
     * Return transportProtocol, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Transport protocol used for communication.
     *     </code>
     * </pre>
     *
     * @return {@code TransportProtocol} transportProtocol, or {@code null} if it is not present.
     *
     */
    TransportProtocol getTransportProtocol();
    
    /**
     * Return transportProtocol, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Transport protocol used for communication.
     *     </code>
     * </pre>
     *
     * @return {@code TransportProtocol} transportProtocol, guaranteed to be non-null.
     * @throws NoSuchElementException if transportProtocol is not present
     *
     */
    default @NonNull TransportProtocol requireTransportProtocol() {
        return CodeHelpers.require(getTransportProtocol(), "transportprotocol");
    }
    
    /**
     * Return channelOutboundQueueSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Channel outbound queue size
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} channelOutboundQueueSize, or {@code null} if it is not present.
     *
     */
    Uint16 getChannelOutboundQueueSize();
    
    /**
     * Return channelOutboundQueueSize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Channel outbound queue size
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} channelOutboundQueueSize, guaranteed to be non-null.
     * @throws NoSuchElementException if channelOutboundQueueSize is not present
     *
     */
    default @NonNull Uint16 requireChannelOutboundQueueSize() {
        return CodeHelpers.require(getChannelOutboundQueueSize(), "channeloutboundqueuesize");
    }
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         address of local listening interface
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, or {@code null} if it is not present.
     *
     */
    IpAddress getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         address of local listening interface
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddress requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return useBarrier, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable barrier in Openflow java
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useBarrier, or {@code null} if it is not present.
     *
     */
    Boolean getUseBarrier();
    
    /**
     * Return useBarrier, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable barrier in Openflow java
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useBarrier, guaranteed to be non-null.
     * @throws NoSuchElementException if useBarrier is not present
     *
     */
    default @NonNull Boolean requireUseBarrier() {
        return CodeHelpers.require(getUseBarrier(), "usebarrier");
    }
    
    /**
     * Return groupAddModEnabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Group Add Mod Enabled
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} groupAddModEnabled, or {@code null} if it is not present.
     *
     */
    Boolean getGroupAddModEnabled();
    
    /**
     * Return groupAddModEnabled, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Group Add Mod Enabled
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} groupAddModEnabled, guaranteed to be non-null.
     * @throws NoSuchElementException if groupAddModEnabled is not present
     *
     */
    default @NonNull Boolean requireGroupAddModEnabled() {
        return CodeHelpers.require(getGroupAddModEnabled(), "groupaddmodenabled");
    }
    
    /**
     * Return switchIdleTimeout, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         idle timeout in [ms]
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} switchIdleTimeout, or {@code null} if it is not present.
     *
     */
    Uint32 getSwitchIdleTimeout();
    
    /**
     * Return switchIdleTimeout, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         idle timeout in [ms]
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} switchIdleTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if switchIdleTimeout is not present
     *
     */
    default @NonNull Uint32 requireSwitchIdleTimeout() {
        return CodeHelpers.require(getSwitchIdleTimeout(), "switchidletimeout");
    }
    
    /**
     * Return tls, or {@code null} if it is not present.
     *
     * @return {@code Tls} tls, or {@code null} if it is not present.
     *
     */
    Tls getTls();
    
    /**
     * Return tls, or an empty instance if it is not present.
     *
     * @return {@code Tls} tls, or an empty instance if it is not present.
     *
     */
    @NonNull Tls nonnullTls();
    
    /**
     * Return threads, or {@code null} if it is not present.
     *
     * @return {@code Threads} threads, or {@code null} if it is not present.
     *
     */
    Threads getThreads();
    
    /**
     * Return threads, or an empty instance if it is not present.
     *
     * @return {@code Threads} threads, or an empty instance if it is not present.
     *
     */
    @NonNull Threads nonnullThreads();

}

