package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Configuration for an Openflow switch connection.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflow-switch-connection-config</b>
 * <pre>
 * module openflow-switch-connection-config {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:openflow:switch:connection:config;
 *   prefix openflow-switch-connection-config;
 *   import ietf-inet-types {
 *     prefix ietf-inet;
 *     revision-date 2013-07-15;
 *   }
 *   import openflow-configuration {
 *     prefix of-config;
 *     revision-date 2014-06-30;
 *   }
 *   revision 2016-05-06 {
 *   }
 *   list switch-connection-config {
 *     key instance-name;
 *     leaf instance-name {
 *       type string;
 *     }
 *     leaf port {
 *       type uint16;
 *     }
 *     leaf transport-protocol {
 *       type of-config:transport-protocol;
 *     }
 *     leaf channel-outbound-queue-size {
 *       type uint16;
 *       default 1024;
 *     }
 *     leaf address {
 *       type ietf-inet:ip-address;
 *     }
 *     leaf use-barrier {
 *       type boolean;
 *       default true;
 *     }
 *     leaf group-add-mod-enabled {
 *       type boolean;
 *       default false;
 *     }
 *     leaf switch-idle-timeout {
 *       type uint32;
 *       default 15000;
 *     }
 *     container tls {
 *       leaf keystore {
 *         type string;
 *       }
 *       leaf keystore-type {
 *         type of-config:keystore-type;
 *       }
 *       leaf keystore-path-type {
 *         type of-config:path-type;
 *       }
 *       leaf keystore-password {
 *         type string;
 *       }
 *       leaf certificate-password {
 *         type string;
 *       }
 *       leaf truststore {
 *         type string;
 *       }
 *       leaf truststore-type {
 *         type of-config:keystore-type;
 *       }
 *       leaf truststore-path-type {
 *         type of-config:path-type;
 *       }
 *       leaf truststore-password {
 *         type string;
 *       }
 *       leaf-list cipher-suites {
 *         type string;
 *         ordered-by user;
 *       }
 *     }
 *     container threads {
 *       leaf boss-threads {
 *         type uint16;
 *       }
 *       leaf worker-threads {
 *         type uint16;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowSwitchConnectionConfigData
    extends
    DataRoot
{




    /**
     * Return switchConnectionConfig, or {@code null} if it is not present.
     *
     * @return {@code Map<SwitchConnectionConfigKey, SwitchConnectionConfig>} switchConnectionConfig, or {@code null} if it is not present.
     *
     */
    @Nullable Map<SwitchConnectionConfigKey, SwitchConnectionConfig> getSwitchConnectionConfig();
    
    /**
     * Return switchConnectionConfig, or an empty list if it is not present.
     *
     * @return {@code Map<SwitchConnectionConfigKey, SwitchConnectionConfig>} switchConnectionConfig, or an empty list if it is not present.
     *
     */
    default @NonNull Map<SwitchConnectionConfigKey, SwitchConnectionConfig> nonnullSwitchConnectionConfig() {
        return CodeHelpers.nonnull(getSwitchConnectionConfig());
    }

}

