/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ResourceTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletContextHelperTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.WebSocketTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.ErrorPageMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.FilterMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.HttpContextMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.JspMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.ListenerMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.ResourceMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.ServletContextHelperMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.ServletMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.legacy.WelcomeFileMappingTracker;
import org.ops4j.pax.web.service.spi.context.DefaultServletContextHelper;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.JspModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.service.whiteboard.FilterMapping;
import org.ops4j.pax.web.service.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.JspMapping;
import org.ops4j.pax.web.service.whiteboard.ListenerMapping;
import org.ops4j.pax.web.service.whiteboard.ResourceMapping;
import org.ops4j.pax.web.service.whiteboard.ServletContextHelperMapping;
import org.ops4j.pax.web.service.whiteboard.ServletMapping;
import org.ops4j.pax.web.service.whiteboard.WelcomeFileMapping;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private WhiteboardExtenderContext whiteboardExtenderContext;
    private ServiceRegistration<ServletContextHelper> registration;
    private final List<ServiceTracker<?, ?>> trackers = new ArrayList();

    public void start(BundleContext bundleContext) throws Exception {
        LOG.info("Starting Pax Web Whiteboard Extender");
        this.context = bundleContext;
        this.whiteboardExtenderContext = new WhiteboardExtenderContext(bundleContext);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        OsgiContextModel defaultContextModel = OsgiContextModel.DEFAULT_CONTEXT_MODEL;
        ((Dictionary)properties).put("osgi.http.whiteboard.context.name", defaultContextModel.getName());
        ((Dictionary)properties).put("osgi.http.whiteboard.context.path", defaultContextModel.getContextPath());
        ((Dictionary)properties).put("osgi.http.whiteboard.context.httpservice", defaultContextModel.getName());
        ((Dictionary)properties).put("service.ranking", defaultContextModel.getServiceRank());
        ((Dictionary)properties).put("org.ops4j.pax.web.internal", true);
        this.registration = bundleContext.registerService(ServletContextHelper.class, (ServiceFactory)new DefaultServletContextHelperServiceFactory(), properties);
        this.trackHttpContexts();
        this.trackServletContextHelpers();
        this.trackServlets();
        this.trackFilters();
        this.trackResources();
        this.trackWelcomeFiles();
        this.trackErrorPages();
        if (Utils.getPaxWebJspBundle((BundleContext)bundleContext) != null) {
            this.trackJspMappings();
        }
        this.trackListeners();
        this.trackWebSockets();
        LOG.debug("Pax Web Whiteboard Extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.debug("Stopping Pax Web Whiteboard Extender");
        this.whiteboardExtenderContext.acceptWabContexts.set(false);
        ArrayList serviceTrackers = new ArrayList(this.trackers);
        Collections.reverse(serviceTrackers);
        for (ServiceTracker serviceTracker : serviceTrackers) {
            serviceTracker.close();
        }
        this.trackers.clear();
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.whiteboardExtenderContext.shutdown();
        LOG.debug("Pax Web Whiteboard Extender stopped");
    }

    private void trackHttpContexts() {
        ServiceTracker<HttpContext, OsgiContextModel> httpContextTracker = HttpContextTracker.createTracker(this.whiteboardExtenderContext, this.context);
        httpContextTracker.open();
        this.trackers.add(0, httpContextTracker);
        ServiceTracker<HttpContextMapping, OsgiContextModel> httpContextMappingTracker = HttpContextMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        httpContextMappingTracker.open();
        this.trackers.add(0, httpContextMappingTracker);
    }

    private void trackServletContextHelpers() {
        ServiceTracker<ServletContextHelper, OsgiContextModel> servletContextHelperTracker = ServletContextHelperTracker.createTracker(this.whiteboardExtenderContext, this.context);
        servletContextHelperTracker.open();
        this.trackers.add(0, servletContextHelperTracker);
        ServiceTracker<ServletContextHelperMapping, OsgiContextModel> servletContextHelperMappingTracker = ServletContextHelperMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        servletContextHelperMappingTracker.open();
        this.trackers.add(0, servletContextHelperMappingTracker);
    }

    private void trackServlets() {
        ServiceTracker<Servlet, ServletModel> servletTracker = ServletTracker.createTracker(this.whiteboardExtenderContext, this.context);
        servletTracker.open();
        this.trackers.add(servletTracker);
        ServiceTracker<ServletMapping, ServletModel> servletMappingTracker = ServletMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        servletMappingTracker.open();
        this.trackers.add(servletMappingTracker);
    }

    private void trackResources() {
        ServiceTracker<Object, ServletModel> resourceTracker = ResourceTracker.createTracker(this.whiteboardExtenderContext, this.context);
        resourceTracker.open();
        this.trackers.add(resourceTracker);
        ServiceTracker<ResourceMapping, ServletModel> resourceMappingTracker = ResourceMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        resourceMappingTracker.open();
        this.trackers.add(resourceMappingTracker);
    }

    private void trackFilters() {
        ServiceTracker<Filter, FilterModel> filterTracker = FilterTracker.createTracker(this.whiteboardExtenderContext, this.context);
        filterTracker.open();
        this.trackers.add(filterTracker);
        ServiceTracker<FilterMapping, FilterModel> filterMappingTracker = FilterMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        filterMappingTracker.open();
        this.trackers.add(filterMappingTracker);
    }

    private void trackWelcomeFiles() {
        ServiceTracker<WelcomeFileMapping, WelcomeFileModel> welcomeFileTracker = WelcomeFileMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        welcomeFileTracker.open();
        this.trackers.add(welcomeFileTracker);
    }

    private void trackErrorPages() {
        ServiceTracker<ErrorPageMapping, ErrorPageModel> errorPagesTracker = ErrorPageMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        errorPagesTracker.open();
        this.trackers.add(errorPagesTracker);
    }

    private void trackListeners() {
        ServiceTracker<EventListener, EventListenerModel> listenerTracker = ListenerTracker.createTracker(this.whiteboardExtenderContext, this.context);
        listenerTracker.open();
        this.trackers.add(listenerTracker);
        ServiceTracker<ListenerMapping, EventListenerModel> listenerMappingTracker = ListenerMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        listenerMappingTracker.open();
        this.trackers.add(listenerMappingTracker);
    }

    private void trackJspMappings() {
        ServiceTracker<JspMapping, JspModel> jspMappingTracker = JspMappingTracker.createTracker(this.whiteboardExtenderContext, this.context);
        jspMappingTracker.open();
        this.trackers.add(jspMappingTracker);
    }

    private void trackWebSockets() {
        ServiceTracker<Object, WebSocketModel> webSocketTracker = WebSocketTracker.createTracker(this.whiteboardExtenderContext, this.context);
        webSocketTracker.open();
        this.trackers.add(webSocketTracker);
    }

    private static class DefaultServletContextHelperServiceFactory
    implements ServiceFactory<ServletContextHelper> {
        private DefaultServletContextHelperServiceFactory() {
        }

        public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
            return new DefaultServletContextHelper(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
        }
    }
}

