/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.websocket.internal;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Endpoint.class, ServerApplicationConfig.class, ServerEndpoint.class})
public class WebSocketsInitializer
implements ServletContainerInitializer {
    public static final Logger LOG = LoggerFactory.getLogger(WebSocketsInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ServerContainer wsContainer = (ServerContainer)ctx.getAttribute(ServerContainer.class.getName());
        if (wsContainer == null) {
            LOG.warn("[dev error] No javax.websocket.server.ServerContainer available in servlet context. Skipping WebSocket registration.");
            return;
        }
        HashSet annotatedEndpointClasses = new HashSet();
        HashSet conigurableEndpoints = new HashSet();
        HashSet<ServerApplicationConfig> configs = new HashSet<ServerApplicationConfig>();
        for (Class<?> potentialEndpointClass : c) {
            int modifiers = potentialEndpointClass.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || potentialEndpointClass.getPackage().getName().startsWith("javax.")) continue;
            if (Endpoint.class.isAssignableFrom(potentialEndpointClass)) {
                conigurableEndpoints.add(potentialEndpointClass);
            }
            if (ServerApplicationConfig.class.isAssignableFrom(potentialEndpointClass)) {
                try {
                    configs.add((ServerApplicationConfig)potentialEndpointClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    LOG.warn("Problem instantiating potentialEndpointClass {}: {}. Skipping", new Object[]{potentialEndpointClass, reflectiveOperationException.getMessage(), reflectiveOperationException});
                }
            }
            if (!potentialEndpointClass.isAnnotationPresent(ServerEndpoint.class)) continue;
            annotatedEndpointClasses.add(potentialEndpointClass);
        }
        HashSet coniguredServerEndpoints = new HashSet();
        HashSet configuredAnnotatedEndpointClasses = new HashSet();
        if (configs.isEmpty()) {
            configuredAnnotatedEndpointClasses.addAll(annotatedEndpointClasses);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : configs) {
                Set configuredEndpointClasses;
                Set configuredEndpoints = serverApplicationConfig.getEndpointConfigs(conigurableEndpoints);
                if (configuredEndpoints != null) {
                    coniguredServerEndpoints.addAll(configuredEndpoints);
                }
                if ((configuredEndpointClasses = serverApplicationConfig.getAnnotatedEndpointClasses(annotatedEndpointClasses)) == null) continue;
                configuredAnnotatedEndpointClasses.addAll(configuredEndpointClasses);
            }
        }
        try {
            for (ServerEndpointConfig serverEndpointConfig : coniguredServerEndpoints) {
                wsContainer.addEndpoint(serverEndpointConfig);
            }
            for (Class clazz : configuredAnnotatedEndpointClasses) {
                wsContainer.addEndpoint(clazz);
            }
        }
        catch (DeploymentException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

