/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Dictionary;
import org.apache.karaf.maven.command.MavenSecuritySupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.maven.settings.Server;

@Command(scope="maven", name="repository-list", description="Maven repository summary.")
@Service
public class RepositoryListCommand
extends MavenSecuritySupport {
    @Option(name="-v", aliases={"--verbose"}, description="Show additional information (policies, source)", required=false, multiValued=false)
    boolean verbose;

    @Override
    public void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        Row row;
        MavenRepositoryURL[] repositories;
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("URL");
        if (this.verbose) {
            table.column("Releases");
            table.column("Snapshots");
            table.column("Defined in");
        }
        if (this.showPasswords) {
            table.column("Username");
            table.column("Password");
        }
        System.out.println();
        System.out.println("== Remote repositories");
        for (MavenRepositoryURL repoURL : repositories = this.repositories(config, true)) {
            row = table.addRow();
            row.addContent(new Object[]{repoURL.getId(), repoURL.getURL()});
            if (this.verbose) {
                row.addContent(new Object[]{this.repositoryKindInfo(repoURL, false), this.repositoryKindInfo(repoURL, true), repoURL.getFrom()});
            }
            if (!this.showPasswords) continue;
            if (this.servers.containsKey(repoURL.getId())) {
                Server server = (Server)this.servers.get(repoURL.getId());
                row.addContent(new Object[]{server.getUsername() == null ? "" : server.getUsername()});
                this.addPasswordInfo(row, this.serverPasswords, repoURL.getId(), server.getPassword());
                continue;
            }
            row.addContent(new Object[]{"", ""});
        }
        table.print(System.out);
        table = new ShellTable();
        table.column("ID");
        table.column("URL");
        if (this.verbose) {
            table.column("Releases");
            table.column("Snapshots");
        }
        System.out.println();
        System.out.println("== Default repositories");
        for (MavenRepositoryURL repoURL : repositories = this.repositories(config, false)) {
            row = table.addRow();
            row.addContent(new Object[]{repoURL.getId(), repoURL.getURL()});
            if (!this.verbose) continue;
            row.addContent(new Object[]{this.repositoryKindInfo(repoURL, false), this.repositoryKindInfo(repoURL, true), repoURL.getFrom()});
        }
        table.print(System.out);
        System.out.println();
    }

    private Object repositoryKindInfo(MavenRepositoryURL repoURL, boolean snapshots) {
        if (snapshots) {
            if (repoURL.isSnapshotsEnabled()) {
                String snapshotsUpdatePolicy = repoURL.getSnapshotsUpdatePolicy();
                return String.format("yes (%s)", snapshotsUpdatePolicy == null || "".equals(snapshotsUpdatePolicy.trim()) ? "daily" : snapshotsUpdatePolicy);
            }
        } else if (repoURL.isReleasesEnabled()) {
            String releasesUpdatePolicy = repoURL.getReleasesUpdatePolicy();
            return String.format("yes (%s)", releasesUpdatePolicy == null || "".equals(releasesUpdatePolicy.trim()) ? "daily" : releasesUpdatePolicy);
        }
        return "no";
    }
}

