/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration;

import java.io.StringWriter;
import java.util.Deque;
import java.util.LinkedList;
import org.ops4j.pax.web.service.undertow.configuration.model.Interface;
import org.ops4j.pax.web.service.undertow.configuration.model.IoSubsystem;
import org.ops4j.pax.web.service.undertow.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.configuration.model.ServletContainer;
import org.ops4j.pax.web.service.undertow.configuration.model.SocketBinding;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowConfiguration;
import org.ops4j.pax.web.service.undertow.configuration.model.UndertowSubsystem;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UnmarshallingContentHandler
implements ContentHandler {
    public static final Logger LOG = LoggerFactory.getLogger(UnmarshallingContentHandler.class);
    public static final String NS_PAXWEB_UNDERTOW = "urn:org.ops4j.pax.web:undertow:1.1";
    public static final String NS_IO = "urn:jboss:domain:io:3.0";
    public static final String NS_UNDERTOW = "urn:jboss:domain:undertow:12.0";
    public static final String NS_WILDFLY = "urn:jboss:domain:17.0";
    private Locator locator;
    private UndertowConfiguration configuration;
    private final Deque<Object> stack = new LinkedList<Object>();
    private StringWriter text;

    public UndertowConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.configuration = new UndertowConfiguration();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (uri == null) {
            throw new SAXException("Unexpected element \"" + localName + "\" without XML namespace");
        }
        switch (uri) {
            case "urn:org.ops4j.pax.web:undertow:1.1": {
                this.handlePaxWebElement(localName, atts, true);
                break;
            }
            case "urn:jboss:domain:undertow:12.0": {
                this.handleUndertowElement(localName, atts, true);
                break;
            }
            case "urn:jboss:domain:17.0": {
                this.handleWildflyElement(localName, atts, true);
                break;
            }
            case "urn:jboss:domain:io:3.0": {
                this.handleIOElement(localName, atts, true);
                break;
            }
            default: {
                throw new SAXException("Unexpected element \"{" + uri + "} + localName.");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null) {
            throw new SAXException("Unexpected end of element \"" + localName + "\" without XML namespace");
        }
        switch (uri) {
            case "urn:org.ops4j.pax.web:undertow:1.1": {
                this.handlePaxWebElement(localName, null, false);
                break;
            }
            case "urn:jboss:domain:undertow:12.0": {
                this.handleUndertowElement(localName, null, false);
                break;
            }
            case "urn:jboss:domain:17.0": {
                this.handleWildflyElement(localName, null, false);
                break;
            }
            case "urn:jboss:domain:io:3.0": {
                this.handleIOElement(localName, null, false);
                break;
            }
            default: {
                throw new SAXException("Unexpected end of element \"{" + uri + "} + localName.");
            }
        }
    }

    private void handlePaxWebElement(String localName, Attributes atts, boolean start) throws SAXParseException {
        switch (localName) {
            case "security-realm": {
                if (start) {
                    this.stack.push(SecurityRealm.create(ParserUtils.toMap(atts)));
                    break;
                }
                this.configuration.getSecurityRealms().add(ParserUtils.ensureStack(this.stack, SecurityRealm.class, localName, this.locator, true));
                break;
            }
            case "interface": {
                if (start) {
                    this.stack.push(Interface.create(ParserUtils.toMap(atts)));
                    break;
                }
                this.configuration.getInterfaces().add(ParserUtils.ensureStack(this.stack, Interface.class, localName, this.locator, true));
                break;
            }
            case "socket-binding": {
                if (start) {
                    this.stack.push(SocketBinding.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                this.configuration.getSocketBindings().add(ParserUtils.ensureStack(this.stack, SocketBinding.class, localName, this.locator, true));
                break;
            }
            case "user-principal-class-name": {
                if (start) {
                    this.text = new StringWriter();
                    break;
                }
                SecurityRealm realm = ParserUtils.ensureStack(this.stack, SecurityRealm.class, localName, this.locator);
                realm.setUserPrincipalClassName(this.text.toString());
                break;
            }
            case "role-principal-class-name": {
                if (start) {
                    this.text = new StringWriter();
                    break;
                }
                SecurityRealm realm = ParserUtils.ensureStack(this.stack, SecurityRealm.class, localName, this.locator);
                realm.getRolePrincipalClassNames().add(this.text.toString());
                break;
            }
        }
    }

    private void handleWildflyElement(String localName, Attributes atts, boolean start) throws SAXParseException {
        switch (localName) {
            case "inet-address": {
                if (start) {
                    this.stack.push(Interface.InetAddress.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Interface.InetAddress address = ParserUtils.ensureStack(this.stack, Interface.InetAddress.class, localName, this.locator, true);
                Interface iface = ParserUtils.ensureStack(this.stack, Interface.class, localName, this.locator);
                iface.getAddresses().add(address);
                break;
            }
            case "server-identities": {
                if (start) {
                    this.stack.push(new SecurityRealm.ServerIdentities());
                    break;
                }
                SecurityRealm.ServerIdentities identities = ParserUtils.ensureStack(this.stack, SecurityRealm.ServerIdentities.class, localName, this.locator, true);
                SecurityRealm realm = ParserUtils.ensureStack(this.stack, SecurityRealm.class, localName, this.locator);
                realm.setIdentities(identities);
                break;
            }
            case "ssl": {
                if (start) {
                    this.stack.push(new SecurityRealm.SSLConfig());
                    break;
                }
                SecurityRealm.SSLConfig sslConfig = ParserUtils.ensureStack(this.stack, SecurityRealm.SSLConfig.class, localName, this.locator, true);
                SecurityRealm.ServerIdentities identities = ParserUtils.ensureStack(this.stack, SecurityRealm.ServerIdentities.class, localName, this.locator);
                identities.setSsl(sslConfig);
                break;
            }
            case "engine": {
                if (start) {
                    this.stack.push(SecurityRealm.Engine.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.Engine engine = ParserUtils.ensureStack(this.stack, SecurityRealm.Engine.class, localName, this.locator, true);
                SecurityRealm.SSLConfig sslConfig = ParserUtils.ensureStack(this.stack, SecurityRealm.SSLConfig.class, localName, this.locator);
                sslConfig.setEngine(engine);
                break;
            }
            case "keystore": {
                if (start) {
                    this.stack.push(SecurityRealm.Keystore.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.Keystore keystore = ParserUtils.ensureStack(this.stack, SecurityRealm.Keystore.class, localName, this.locator, true);
                SecurityRealm.SSLConfig sslConfig = ParserUtils.ensureStack(this.stack, SecurityRealm.SSLConfig.class, localName, this.locator);
                sslConfig.setKeystore(keystore);
                break;
            }
            case "authentication": {
                if (start) {
                    this.stack.push(new SecurityRealm.Authentication());
                    break;
                }
                SecurityRealm.Authentication auth = ParserUtils.ensureStack(this.stack, SecurityRealm.Authentication.class, localName, this.locator, true);
                SecurityRealm realm = ParserUtils.ensureStack(this.stack, SecurityRealm.class, localName, this.locator);
                realm.setAuthentication(auth);
                break;
            }
            case "truststore": {
                if (start) {
                    this.stack.push(SecurityRealm.Truststore.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.Truststore truststore = ParserUtils.ensureStack(this.stack, SecurityRealm.Truststore.class, localName, this.locator, true);
                SecurityRealm.Authentication auth = ParserUtils.ensureStack(this.stack, SecurityRealm.Authentication.class, localName, this.locator);
                auth.setTruststore(truststore);
                break;
            }
            case "jaas": {
                if (start) {
                    this.stack.push(SecurityRealm.JaasAuth.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.JaasAuth jaas = ParserUtils.ensureStack(this.stack, SecurityRealm.JaasAuth.class, localName, this.locator, true);
                SecurityRealm.Authentication auth = ParserUtils.ensureStack(this.stack, SecurityRealm.Authentication.class, localName, this.locator);
                auth.setJaas(jaas);
                break;
            }
            case "properties": {
                if (start) {
                    this.stack.push(SecurityRealm.PropertiesAuth.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.PropertiesAuth propertiesAuth = ParserUtils.ensureStack(this.stack, SecurityRealm.PropertiesAuth.class, localName, this.locator, true);
                SecurityRealm.Authentication auth = ParserUtils.ensureStack(this.stack, SecurityRealm.Authentication.class, localName, this.locator);
                auth.setProperties(propertiesAuth);
                break;
            }
            case "users": {
                if (start) {
                    this.stack.push(new SecurityRealm.UsersAuth());
                    break;
                }
                SecurityRealm.UsersAuth usersAuth = ParserUtils.ensureStack(this.stack, SecurityRealm.UsersAuth.class, localName, this.locator, true);
                SecurityRealm.Authentication auth = ParserUtils.ensureStack(this.stack, SecurityRealm.Authentication.class, localName, this.locator);
                auth.setUsers(usersAuth);
                break;
            }
            case "user": {
                if (start) {
                    this.stack.push(SecurityRealm.User.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                SecurityRealm.User user = ParserUtils.ensureStack(this.stack, SecurityRealm.User.class, localName, this.locator, true);
                SecurityRealm.UsersAuth auth = ParserUtils.ensureStack(this.stack, SecurityRealm.UsersAuth.class, localName, this.locator);
                auth.getUsers().add(user);
                break;
            }
            case "password": {
                if (start) {
                    this.text = new StringWriter();
                    break;
                }
                SecurityRealm.User user = ParserUtils.ensureStack(this.stack, SecurityRealm.User.class, localName, this.locator);
                user.setPassword(this.text.toString());
                break;
            }
        }
    }

    private void handleUndertowElement(String localName, Attributes atts, boolean start) throws SAXParseException {
        switch (localName) {
            case "subsystem": {
                if (start) {
                    this.stack.push(new UndertowSubsystem());
                    break;
                }
                this.configuration.setSubsystem(ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator, true));
                break;
            }
            case "buffer-cache": {
                if (start) {
                    this.stack.push(UndertowSubsystem.BufferCache.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.BufferCache cache = ParserUtils.ensureStack(this.stack, UndertowSubsystem.BufferCache.class, localName, this.locator, true);
                UndertowSubsystem subsystem = ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator);
                subsystem.setBufferCache(cache);
                break;
            }
            case "handlers": {
                if (start) {
                    this.stack.push(new LinkedList());
                    break;
                }
                LinkedList handlers = ParserUtils.ensureStack(this.stack, LinkedList.class, localName, this.locator, true);
                UndertowSubsystem subsystem = ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator);
                subsystem.getFileHandlers().addAll(handlers);
                break;
            }
            case "file": {
                if (start) {
                    this.stack.push(UndertowSubsystem.FileHandler.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.FileHandler fileHandler = ParserUtils.ensureStack(this.stack, UndertowSubsystem.FileHandler.class, localName, this.locator, true);
                LinkedList handlers = ParserUtils.ensureStack(this.stack, LinkedList.class, localName, this.locator);
                handlers.add(fileHandler);
                break;
            }
            case "filters": {
                if (start) {
                    this.stack.push(new UndertowSubsystem.Filters());
                    break;
                }
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator, true);
                UndertowSubsystem subsystem = ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator);
                subsystem.setFilters(filters);
                break;
            }
            case "response-header": {
                if (start) {
                    this.stack.push(UndertowSubsystem.ResponseHeaderFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.ResponseHeaderFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.ResponseHeaderFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getResponseHeaders().add(filter);
                break;
            }
            case "error-page": {
                if (start) {
                    this.stack.push(UndertowSubsystem.ErrorPageFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.ErrorPageFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.ErrorPageFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getErrorPages().add(filter);
                break;
            }
            case "filter": {
                if (start) {
                    this.stack.push(UndertowSubsystem.CustomFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.CustomFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.CustomFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getCustomFilters().add(filter);
                break;
            }
            case "expression-filter": {
                if (start) {
                    this.stack.push(UndertowSubsystem.ExpressionFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.ExpressionFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.ExpressionFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getExpressionFilters().add(filter);
                break;
            }
            case "gzip": {
                if (start) {
                    this.stack.push(UndertowSubsystem.GzipFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.GzipFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.GzipFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getGzipFilters().add(filter);
                break;
            }
            case "request-limit": {
                if (start) {
                    this.stack.push(UndertowSubsystem.RequestLimitFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.RequestLimitFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.RequestLimitFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getRequestLimitFilters().add(filter);
                break;
            }
            case "rewrite": {
                if (start) {
                    this.stack.push(UndertowSubsystem.RewriteFilter.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                UndertowSubsystem.RewriteFilter filter = ParserUtils.ensureStack(this.stack, UndertowSubsystem.RewriteFilter.class, localName, this.locator, true);
                UndertowSubsystem.Filters filters = ParserUtils.ensureStack(this.stack, UndertowSubsystem.Filters.class, localName, this.locator);
                filters.getRewriteFilters().add(filter);
                break;
            }
            case "servlet-container": {
                if (start) {
                    this.stack.push(ServletContainer.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator, true);
                UndertowSubsystem subsystem = ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator);
                subsystem.setServletContainer(container);
                break;
            }
            case "jsp-config": {
                if (start) {
                    this.stack.push(new ServletContainer.JspConfig());
                    break;
                }
                ServletContainer.JspConfig config = ParserUtils.ensureStack(this.stack, ServletContainer.JspConfig.class, localName, this.locator, true);
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator);
                container.setJspConfig(config);
                break;
            }
            case "persistent-sessions": {
                if (start) {
                    this.stack.push(ServletContainer.PersistentSessionsConfig.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                ServletContainer.PersistentSessionsConfig config = ParserUtils.ensureStack(this.stack, ServletContainer.PersistentSessionsConfig.class, localName, this.locator, true);
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator);
                container.setPersistentSessions(config);
                break;
            }
            case "websockets": {
                if (start) {
                    this.stack.push(ServletContainer.Websockets.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                ServletContainer.Websockets websockets = ParserUtils.ensureStack(this.stack, ServletContainer.Websockets.class, localName, this.locator, true);
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator);
                container.setWebsockets(websockets);
                break;
            }
            case "welcome-files": {
                if (start) {
                    this.stack.push(new LinkedList());
                    break;
                }
                LinkedList files = ParserUtils.ensureStack(this.stack, LinkedList.class, localName, this.locator, true);
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator);
                container.getWelcomeFiles().addAll(files);
                break;
            }
            case "welcome-file": {
                if (start) {
                    this.stack.push(ServletContainer.WelcomeFile.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                ServletContainer.WelcomeFile wf = ParserUtils.ensureStack(this.stack, ServletContainer.WelcomeFile.class, localName, this.locator, true);
                LinkedList files = ParserUtils.ensureStack(this.stack, LinkedList.class, localName, this.locator);
                files.add(wf);
                break;
            }
            case "session-cookie": {
                if (start) {
                    this.stack.push(ServletContainer.SessionCookie.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                ServletContainer.SessionCookie cookie = ParserUtils.ensureStack(this.stack, ServletContainer.SessionCookie.class, localName, this.locator, true);
                ServletContainer container = ParserUtils.ensureStack(this.stack, ServletContainer.class, localName, this.locator);
                container.setSessionCookie(cookie);
                break;
            }
            case "server": {
                if (start) {
                    this.stack.push(Server.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server server = ParserUtils.ensureStack(this.stack, Server.class, localName, this.locator, true);
                UndertowSubsystem subsystem = ParserUtils.ensureStack(this.stack, UndertowSubsystem.class, localName, this.locator);
                subsystem.setServer(server);
                break;
            }
            case "http-listener": {
                if (start) {
                    this.stack.push(Server.HttpListener.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.HttpListener listener = ParserUtils.ensureStack(this.stack, Server.HttpListener.class, localName, this.locator, true);
                Server server = ParserUtils.ensureStack(this.stack, Server.class, localName, this.locator);
                server.getHttpListeners().add(listener);
                break;
            }
            case "https-listener": {
                if (start) {
                    this.stack.push(Server.HttpsListener.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.HttpsListener listener = ParserUtils.ensureStack(this.stack, Server.HttpsListener.class, localName, this.locator, true);
                Server server = ParserUtils.ensureStack(this.stack, Server.class, localName, this.locator);
                server.getHttpsListeners().add(listener);
                break;
            }
            case "host": {
                if (start) {
                    this.stack.push(Server.Host.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.Host host = ParserUtils.ensureStack(this.stack, Server.Host.class, localName, this.locator, true);
                Server server = ParserUtils.ensureStack(this.stack, Server.class, localName, this.locator);
                server.setHost(host);
                break;
            }
            case "location": {
                if (start) {
                    this.stack.push(Server.Host.Location.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.Host.Location location = ParserUtils.ensureStack(this.stack, Server.Host.Location.class, localName, this.locator, true);
                Server.Host host = ParserUtils.ensureStack(this.stack, Server.Host.class, localName, this.locator);
                host.getLocations().add(location);
                break;
            }
            case "access-log": {
                if (start) {
                    this.stack.push(Server.Host.AccessLog.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.Host.AccessLog accessLog = ParserUtils.ensureStack(this.stack, Server.Host.AccessLog.class, localName, this.locator, true);
                Server.Host host = ParserUtils.ensureStack(this.stack, Server.Host.class, localName, this.locator);
                host.setAccessLog(accessLog);
                break;
            }
            case "filter-ref": {
                if (start) {
                    this.stack.push(Server.Host.FilterRef.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                Server.Host.FilterRef filter = ParserUtils.ensureStack(this.stack, Server.Host.FilterRef.class, localName, this.locator, true);
                if (this.stack.peek() instanceof Server.Host) {
                    Server.Host host = ParserUtils.ensureStack(this.stack, Server.Host.class, localName, this.locator);
                    host.getFilterRefs().add(filter);
                    break;
                }
                if (!(this.stack.peek() instanceof Server.Host.Location)) break;
                Server.Host.Location location = ParserUtils.ensureStack(this.stack, Server.Host.Location.class, localName, this.locator);
                location.getFilterRefs().add(filter);
                break;
            }
        }
    }

    private void handleIOElement(String localName, Attributes atts, boolean start) throws SAXParseException {
        switch (localName) {
            case "subsystem": {
                if (start) {
                    this.stack.push(new IoSubsystem());
                    break;
                }
                this.configuration.setIoSubsystem(ParserUtils.ensureStack(this.stack, IoSubsystem.class, localName, this.locator, true));
                break;
            }
            case "worker": {
                if (start) {
                    this.stack.push(IoSubsystem.Worker.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                IoSubsystem.Worker worker = ParserUtils.ensureStack(this.stack, IoSubsystem.Worker.class, localName, this.locator, true);
                IoSubsystem ioSubsystem = ParserUtils.ensureStack(this.stack, IoSubsystem.class, localName, this.locator);
                ioSubsystem.getWorkers().add(worker);
                break;
            }
            case "buffer-pool": {
                if (start) {
                    this.stack.push(IoSubsystem.BufferPool.create(ParserUtils.toMap(atts), this.locator));
                    break;
                }
                IoSubsystem.BufferPool pool = ParserUtils.ensureStack(this.stack, IoSubsystem.BufferPool.class, localName, this.locator, true);
                IoSubsystem ioSubsystem = ParserUtils.ensureStack(this.stack, IoSubsystem.class, localName, this.locator);
                ioSubsystem.getBufferPools().add(pool);
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.write(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }
}

