/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.configuration.model;

import io.undertow.Handlers;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.RequestLimitingHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ops4j.pax.web.service.undertow.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.configuration.model.ServletContainer;
import org.ops4j.pax.web.service.undertow.internal.configuration.ParserUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class UndertowSubsystem {
    private BufferCache bufferCache;
    private Server server;
    private ServletContainer servletContainer;
    private final List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
    private Filters filters;

    public BufferCache getBufferCache() {
        return this.bufferCache;
    }

    public void setBufferCache(BufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public List<FileHandler> getFileHandlers() {
        return this.fileHandlers;
    }

    public String toString() {
        return "{\n\t\tbuffer cache: " + this.bufferCache + "\n\t\tserver: " + this.server + "\n\t\tservlet container: " + this.servletContainer + "\n\t}";
    }

    public static class RewriteFilter
    extends AbstractFilter {
        private static final QName ATT_TARGET = new QName("target");
        private static final QName ATT_REDIRECT = new QName("redirect");
        private String target;
        private String redirect;

        public static RewriteFilter create(Map<QName, String> attributes, Locator locator) {
            RewriteFilter filter = new RewriteFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.target = attributes.get(ATT_TARGET);
            filter.redirect = attributes.get(ATT_REDIRECT);
            return filter;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getRedirect() {
            return this.redirect;
        }

        public void setRedirect(String redirect) {
            this.redirect = redirect;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            Object redirectHandler = "true".equalsIgnoreCase(this.redirect) ? new RedirectHandler(this.target) : new SetAttributeHandler(handler, ExchangeAttributes.relativePath(), ExchangeAttributes.parser((ClassLoader)HttpHandler.class.getClassLoader()).parse(this.target));
            if (predicate == null) {
                return redirectHandler;
            }
            return Handlers.predicate((Predicate)predicate, (HttpHandler)redirectHandler, (HttpHandler)handler);
        }
    }

    public static class RequestLimitFilter
    extends AbstractFilter {
        private static final QName ATT_MAX_CONCURRENT_REQUESTS = new QName("max-concurrent-requests");
        private static final QName ATT_QUEUE_SIZE = new QName("queue-size");
        private Integer maxConcurrentRequests = 100;
        private Integer queueSize = 0;

        public static RequestLimitFilter create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            RequestLimitFilter filter = new RequestLimitFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.maxConcurrentRequests = ParserUtils.toInteger(attributes.get(ATT_MAX_CONCURRENT_REQUESTS), locator, 100);
            filter.queueSize = ParserUtils.toInteger(attributes.get(ATT_QUEUE_SIZE), locator, 0);
            return filter;
        }

        public Integer getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(Integer maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }

        public Integer getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(Integer queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            RequestLimitingHandler requestLimitingHandler = new RequestLimitingHandler(this.maxConcurrentRequests.intValue(), this.queueSize.intValue(), handler);
            if (predicate == null) {
                return requestLimitingHandler;
            }
            return Handlers.predicate((Predicate)predicate, (HttpHandler)requestLimitingHandler, (HttpHandler)handler);
        }
    }

    public static class GzipFilter
    extends AbstractFilter {
        public static GzipFilter create(Map<QName, String> attributes, Locator locator) {
            GzipFilter filter = new GzipFilter();
            filter.name = attributes.get(ATT_NAME);
            return filter;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            if (predicate == null) {
                predicate = Predicates.truePredicate();
            }
            return new EncodingHandler(handler, new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 50, predicate));
        }
    }

    public static class ExpressionFilter
    extends AbstractFilter {
        private static final QName ATT_EXPRESSION = new QName("expression");
        private static final QName ATT_MODULE = new QName("module");
        private String expression;
        private String module;

        public static ExpressionFilter create(Map<QName, String> attributes, Locator locator) {
            ExpressionFilter filter = new ExpressionFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.expression = attributes.get(ATT_EXPRESSION);
            filter.module = attributes.get(ATT_MODULE);
            return filter;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            List handlers = PredicatedHandlersParser.parse((String)this.expression, (ClassLoader)HttpHandler.class.getClassLoader());
            if (predicate == null) {
                return Handlers.predicates((List)handlers, (HttpHandler)handler);
            }
            return Handlers.predicate((Predicate)predicate, (HttpHandler)Handlers.predicates((List)handlers, (HttpHandler)handler), (HttpHandler)handler);
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }
    }

    public static class CustomFilter
    extends AbstractFilter {
        private static final QName ATT_CLASS_NAME = new QName("class-name");
        private static final QName ATT_MODULE = new QName("module");
        private String className;
        private String module;

        public static CustomFilter create(Map<QName, String> attributes, Locator locator) {
            CustomFilter filter = new CustomFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.className = attributes.get(ATT_CLASS_NAME);
            filter.module = attributes.get(ATT_MODULE);
            return filter;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            return handler;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }
    }

    public static class ErrorPageFilter
    extends AbstractFilter {
        private static final QName ATT_CODE = new QName("code");
        private static final QName ATT_PATH = new QName("path");
        private String code;
        private String path;

        public static ErrorPageFilter create(Map<QName, String> attributes, Locator locator) {
            ErrorPageFilter filter = new ErrorPageFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.code = attributes.get(ATT_CODE);
            filter.path = attributes.get(ATT_PATH);
            return filter;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            return handler;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class ResponseHeaderFilter
    extends AbstractFilter {
        private static final QName ATT_HEADER_NAME = new QName("header-name");
        private static final QName ATT_HEADER_VALUE = new QName("header-value");
        private String header;
        private String value;

        public static ResponseHeaderFilter create(Map<QName, String> attributes, Locator locator) {
            ResponseHeaderFilter filter = new ResponseHeaderFilter();
            filter.name = attributes.get(ATT_NAME);
            filter.header = attributes.get(ATT_HEADER_NAME);
            filter.value = attributes.get(ATT_HEADER_VALUE);
            return filter;
        }

        @Override
        public HttpHandler configure(HttpHandler handler, Predicate predicate) {
            SetHeaderHandler setHeaderHandler = new SetHeaderHandler(handler, this.header, this.value);
            if (predicate == null) {
                return setHeaderHandler;
            }
            return Handlers.predicate((Predicate)predicate, (HttpHandler)setHeaderHandler, (HttpHandler)handler);
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static abstract class AbstractFilter {
        protected static final QName ATT_NAME = new QName("name");
        protected String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract HttpHandler configure(HttpHandler var1, Predicate var2);
    }

    public static class Filters {
        private final List<ResponseHeaderFilter> responseHeaders = new ArrayList<ResponseHeaderFilter>();
        private final List<ErrorPageFilter> errorPages = new ArrayList<ErrorPageFilter>();
        private final List<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        private final List<ExpressionFilter> expressionFilters = new ArrayList<ExpressionFilter>();
        private final List<GzipFilter> gzipFilters = new ArrayList<GzipFilter>();
        private final List<RequestLimitFilter> requestLimitFilters = new ArrayList<RequestLimitFilter>();
        private final List<RewriteFilter> rewriteFilters = new ArrayList<RewriteFilter>();

        public List<ResponseHeaderFilter> getResponseHeaders() {
            return this.responseHeaders;
        }

        public List<ErrorPageFilter> getErrorPages() {
            return this.errorPages;
        }

        public List<CustomFilter> getCustomFilters() {
            return this.customFilters;
        }

        public List<ExpressionFilter> getExpressionFilters() {
            return this.expressionFilters;
        }

        public List<GzipFilter> getGzipFilters() {
            return this.gzipFilters;
        }

        public List<RequestLimitFilter> getRequestLimitFilters() {
            return this.requestLimitFilters;
        }

        public List<RewriteFilter> getRewriteFilters() {
            return this.rewriteFilters;
        }
    }

    public static class FileHandler {
        private static final QName ATT_NAME = new QName("name");
        private static final QName ATT_PATH = new QName("path");
        private static final QName ATT_CACHE_BUFFER_SIZE = new QName("cache-buffer-size");
        private static final QName ATT_CACHE_BUFFERS = new QName("cache-buffers");
        private static final QName ATT_DIRECTORY_LISTING = new QName("directory-listing");
        private static final QName ATT_FOLLOW_SYMLINKS = new QName("follow-symlink");
        private static final QName ATT_CASE_SENSITIVE = new QName("case-sensitive");
        private static final QName ATT_SAFE_SYMLINK_PATHS = new QName("safe-symlink-paths");
        private String name;
        private String path;
        private Integer cacheBufferSize = 1024;
        private Integer cacheBuffers = 1024;
        private Boolean directoryListing = false;
        private Boolean followSymlink = false;
        private Boolean caseSensitive = true;
        private final List<String> safeSymlinkPaths = new ArrayList<String>();

        public static FileHandler create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            FileHandler handler = new FileHandler();
            handler.name = attributes.get(ATT_NAME);
            handler.path = attributes.get(ATT_PATH);
            handler.cacheBufferSize = ParserUtils.toInteger(attributes.get(ATT_CACHE_BUFFER_SIZE), locator, 1024);
            handler.cacheBuffers = ParserUtils.toInteger(attributes.get(ATT_CACHE_BUFFERS), locator, 1024);
            handler.directoryListing = ParserUtils.toBoolean(attributes.get(ATT_DIRECTORY_LISTING), locator, false);
            handler.followSymlink = ParserUtils.toBoolean(attributes.get(ATT_FOLLOW_SYMLINKS), locator, false);
            handler.caseSensitive = ParserUtils.toBoolean(attributes.get(ATT_CASE_SENSITIVE), locator, true);
            handler.safeSymlinkPaths.addAll(ParserUtils.toStringList(attributes.get(ATT_SAFE_SYMLINK_PATHS), locator));
            return handler;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Integer getCacheBufferSize() {
            return this.cacheBufferSize;
        }

        public void setCacheBufferSize(Integer cacheBufferSize) {
            this.cacheBufferSize = cacheBufferSize;
        }

        public Integer getCacheBuffers() {
            return this.cacheBuffers;
        }

        public void setCacheBuffers(Integer cacheBuffers) {
            this.cacheBuffers = cacheBuffers;
        }

        public Boolean getDirectoryListing() {
            return this.directoryListing;
        }

        public void setDirectoryListing(Boolean directoryListing) {
            this.directoryListing = directoryListing;
        }

        public Boolean getFollowSymlink() {
            return this.followSymlink;
        }

        public void setFollowSymlink(Boolean followSymlink) {
            this.followSymlink = followSymlink;
        }

        public Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public List<String> getSafeSymlinkPaths() {
            return this.safeSymlinkPaths;
        }
    }

    public static class BufferCache {
        private static final QName ATT_NAME = new QName("name");
        private static final QName ATT_BUFFER_SIZE = new QName("buffer-size");
        private static final QName ATT_BUFFERS_PER_REGION = new QName("buffers-per-region");
        private static final QName ATT_MAX_REGIONS = new QName("max-regions");
        private String name;
        private int bufferSize = 1024;
        private int buffersPerRegion = 1024;
        private int maxRegions = 10;

        public static BufferCache create(Map<QName, String> attributes, Locator locator) throws SAXParseException {
            BufferCache cache = new BufferCache();
            cache.name = attributes.get(ATT_NAME);
            cache.bufferSize = ParserUtils.toInteger(attributes.get(ATT_BUFFER_SIZE), locator, 1024);
            cache.buffersPerRegion = ParserUtils.toInteger(attributes.get(ATT_BUFFERS_PER_REGION), locator, 1024);
            cache.maxRegions = ParserUtils.toInteger(attributes.get(ATT_MAX_REGIONS), locator, 10);
            return cache;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public int getBuffersPerRegion() {
            return this.buffersPerRegion;
        }

        public void setBuffersPerRegion(int buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
        }

        public int getMaxRegions() {
            return this.maxRegions;
        }

        public void setMaxRegions(int maxRegions) {
            this.maxRegions = maxRegions;
        }

        public String toString() {
            return "{ name: " + this.name + ", buffer size: " + this.bufferSize + ", buffers per region: " + this.buffersPerRegion + ", max regions: " + this.maxRegions + " }";
        }
    }
}

