/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.Default404Servlet;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebSessionIdGenerator;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardWrapper;

public class PaxWebStandardContextValve
extends ValveBase {
    private final PaxWebStandardWrapper wrapperFor404Servlet;

    public PaxWebStandardContextValve(ValveBase next, Default404Servlet defaultServlet) {
        this.setNext(next);
        this.setAsyncSupported(next.isAsyncSupported());
        this.setContainer(next.getContainer());
        this.setDomain(next.getDomain());
        this.wrapperFor404Servlet = new PaxWebStandardWrapper("404", (PaxWebStandardContext)this.getContainer(), (Servlet)defaultServlet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF") || requestPathMB.startsWithIgnoreCase("/OSGI-INF/", 0) || requestPathMB.equalsIgnoreCase("/OSGI-INF") || requestPathMB.startsWithIgnoreCase("/OSGI-OPT/", 0) || requestPathMB.equalsIgnoreCase("/OSGI-OPT")) {
            response.sendError(404);
            return;
        }
        PaxWebStandardContext ctx = (PaxWebStandardContext)this.getContainer();
        if (!ctx.matches(request.getServerName(), (String)request.getConnector().getProperty("PaxWebConnectorName"))) {
            response.sendError(404);
            return;
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null) {
            request.getMappingData().wrapper = this.wrapperFor404Servlet;
        }
        if (wrapper instanceof PaxWebStandardWrapper) {
            OsgiContextModel osgiContextModel;
            PaxWebStandardWrapper pwrapper = (PaxWebStandardWrapper)wrapper;
            Object object = !pwrapper.is404() ? pwrapper.getOsgiContextModel() : (osgiContextModel = this.getContainer() instanceof PaxWebStandardContext ? ((PaxWebStandardContext)this.getContainer()).getDefaultOsgiContextModel() : null);
            if (osgiContextModel != null) {
                String sessionIdPrefix = osgiContextModel.getTemporaryLocation().replaceAll("/", "_");
                PaxWebSessionIdGenerator.sessionIdPrefix.set(sessionIdPrefix);
            }
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctx.getServletContext() == null ? tccl : ctx.getServletContext().getClassLoader());
            this.getNext().invoke(request, response);
        }
        finally {
            PaxWebSessionIdGenerator.sessionIdPrefix.set(null);
            PaxWebSessionIdGenerator.cookieSessionId.set(null);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

