/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.ops4j.pax.exam.TestProbeBuilder;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void addAllClassesInSameAndSubPackageOfClass(TestProbeBuilder probe, Class<?> clazz) {
        ReflectionUtil.addAllClassesInSameAndSubPackageOfPackage(probe, clazz.getPackage().getName());
    }

    public static void addAllClassesInSameAndSubPackageOfPackage(TestProbeBuilder probe, String packageName) {
        ReflectionUtil.getClasses(ReflectionUtil.class.getClassLoader(), packageName).forEach(eachClass -> probe.addTest(eachClass, new Object[0]));
    }

    public static Stream<Class<?>> getClasses(ClassLoader classLoader, String packageName) {
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            return classPath.getTopLevelClassesRecursive(packageName).stream().map(ClassPath.ClassInfo::load).flatMap(ReflectionUtil::getDeclaredAndAnonymousInnerClass);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to examine class loader " + classLoader, e);
        }
    }

    private static Stream<Class<?>> getDeclaredAndAnonymousInnerClass(Class<?> clazz) {
        ArrayList anonymousInnerClasses = new ArrayList();
        anonymousInnerClasses.add(clazz);
        anonymousInnerClasses.addAll(Arrays.asList(clazz.getDeclaredClasses()));
        ClassLoader classLoader = clazz.getClassLoader();
        String className = clazz.getCanonicalName();
        int i = 1;
        while (true) {
            try {
                anonymousInnerClasses.add(classLoader.loadClass(className + "$" + i));
            }
            catch (ClassNotFoundException e) {
                return anonymousInnerClasses.stream();
            }
            catch (NoClassDefFoundError e) {
                return Stream.empty();
            }
            ++i;
        }
    }
}

