/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.opendaylight.odlparent.featuretest.PerFeatureRunner;
import org.opendaylight.odlparent.karafutil.CustomBundleUrlStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerRepoTestRunner
extends ParentRunner<PerFeatureRunner> {
    private static final Logger LOG = LoggerFactory.getLogger(PerRepoTestRunner.class);
    private static final String REPO_RECURSE = "repo.recurse";
    private static final String[] FEATURES_FILENAMES = new String[]{"features.xml", "feature.xml"};
    private static boolean isURLStreamHandlerFactorySet = false;
    private final List<PerFeatureRunner> children = new ArrayList<PerFeatureRunner>();

    public PerRepoTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        PerRepoTestRunner.setURLStreamHandlerFactory();
        try {
            for (String filename : FEATURES_FILENAMES) {
                URL repoUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(filename);
                if (repoUrl == null) continue;
                boolean recursive = Boolean.getBoolean(REPO_RECURSE);
                LOG.info("Creating test runners for repoUrl {} recursive {}", (Object)repoUrl, (Object)recursive);
                this.children.addAll(this.runnersFromRepoUrl(repoUrl, testClass, recursive));
            }
            if (this.children.isEmpty()) {
                LOG.error("No features found to test; looked for {}", (Object)Arrays.toString(FEATURES_FILENAMES));
            }
        }
        catch (IOException | JAXBException e) {
            throw new InitializationError(e);
        }
    }

    private static synchronized void setURLStreamHandlerFactory() {
        if (!isURLStreamHandlerFactorySet) {
            try {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new CustomBundleUrlStreamHandlerFactory());
                isURLStreamHandlerFactorySet = true;
            }
            catch (Error e) {
                LOG.warn("Failed to setURLStreamHandlerFactory to CustomBundleUrlStreamHandlerFactory (depending on which is already set, this may or may not actually be a problem; e.g. Karaf 4 already registers the neccessary handlers, so OK to ignore)", (Throwable)e);
            }
        }
    }

    protected List<PerFeatureRunner> runnersFromRepoUrl(URL repoUrl, Class<?> testClass, boolean recursive) throws JAXBException, IOException, InitializationError {
        if (recursive) {
            return this.recursiveRunnersFromRepoUrl(repoUrl, testClass);
        }
        return this.runnersFromRepoUrl(repoUrl, testClass);
    }

    protected List<PerFeatureRunner> runnersFromRepoUrl(URL repoUrl, Class<?> testClass) throws JAXBException, IOException, InitializationError {
        ArrayList<PerFeatureRunner> runners = new ArrayList<PerFeatureRunner>();
        Features features = this.getFeatures(repoUrl);
        runners.addAll(this.runnersFromFeatures(repoUrl, features, testClass));
        return runners;
    }

    protected List<PerFeatureRunner> recursiveRunnersFromRepoUrl(URL repoUrl, Class<?> testClass) throws JAXBException, IOException, InitializationError {
        ArrayList<PerFeatureRunner> runners = new ArrayList<PerFeatureRunner>();
        Features features = this.getFeatures(repoUrl);
        runners.addAll(this.runnersFromRepoUrl(repoUrl, testClass));
        for (String repoString : features.getRepository()) {
            URL subRepoUrl = new URL(repoString);
            runners.addAll(this.recursiveRunnersFromRepoUrl(subRepoUrl, testClass));
        }
        return runners;
    }

    protected List<PerFeatureRunner> runnersFromFeatures(URL repoUrl, Features features, Class<?> testClass) throws InitializationError {
        ArrayList<PerFeatureRunner> runners = new ArrayList<PerFeatureRunner>();
        List featureList = features.getFeature();
        for (Feature f : featureList) {
            if (featureList.size() == 1 || !f.getName().equals(features.getName())) {
                runners.add(new PerFeatureRunner(repoUrl, f.getName(), f.getVersion(), testClass));
                continue;
            }
            LOG.warn("Skipping {}, it's an aggregator feature", (Object)f.getName());
        }
        return runners;
    }

    protected Features getFeatures(URL repoUrl) throws JAXBException, IOException {
        return JaxbUtil.unmarshal((String)repoUrl.toExternalForm(), (boolean)false);
    }

    protected List<PerFeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(PerFeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(PerFeatureRunner child, RunNotifier notifier) {
        LOG.info("[LOG] About to run test: {}", (Object)child.getDescription());
        System.out.println("[sys.out] About to run test: " + child.getDescription());
        child.run(notifier);
    }

    public int testCount() {
        return super.testCount() * this.children.size();
    }
}

