/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KarafConstants {
    private static final Logger LOG = LoggerFactory.getLogger(KarafConstants.class);
    private static final String PROPERTIES_FILENAME = "/singlefeaturetest.properties";
    private static final String KARAF_DISTRO_VERSION_PROP = "karaf.distro.version";
    private static final String KARAF_RELEASE_VERSION_PROP = "karaf.release.version";
    private static final @NonNull String KARAF_DISTRO_VERSION;
    private static final @NonNull String KARAF_RELEASE_VERSION;

    private KarafConstants() {
    }

    static @NonNull String karafDistroVersion() {
        return KarafConstants.systemOrFile(KARAF_DISTRO_VERSION_PROP, KARAF_DISTRO_VERSION);
    }

    static @NonNull String karafReleaseVersion() {
        return KarafConstants.systemOrFile(KARAF_RELEASE_VERSION_PROP, KARAF_RELEASE_VERSION);
    }

    private static @NonNull String systemOrFile(String key, @NonNull String fileVal) {
        String ret = System.getProperty(key);
        if (ret == null) {
            ret = fileVal;
            LOG.info("Retrieved {} value {} from properties file {}", new Object[]{key, ret, key});
        } else {
            LOG.info("Retrieved {} value {} from system properties", (Object)key, (Object)ret);
        }
        return ret;
    }

    private static @NonNull String nonnullProp(Properties props, String key) {
        String ret = props.getProperty(Objects.requireNonNull(key));
        if (ret == null) {
            throw new IllegalStateException("Property \"" + key + "\" not found");
        }
        return ret;
    }

    static {
        InputStream input = KarafConstants.class.getResourceAsStream(PROPERTIES_FILENAME);
        if (input == null) {
            throw new IllegalStateException("Failed to open resource \"/singlefeaturetest.properties\"");
        }
        Properties props = new Properties();
        try {
            props.load(input);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        KARAF_DISTRO_VERSION = KarafConstants.nonnullProp(props, KARAF_DISTRO_VERSION_PROP);
        KARAF_RELEASE_VERSION = KarafConstants.nonnullProp(props, KARAF_RELEASE_VERSION_PROP);
    }
}

