/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.copy.files.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="copy-files", threadSafe=true)
public class CopyFilesMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}", readonly=true)
    private File gitRepoRootDir;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}", readonly=true)
    private File target;
    @Parameter(required=true)
    private List<String> globs;

    public void execute() throws MojoExecutionException {
        Path parent;
        Path srcDir = this.gitRepoRootDir.toPath();
        while (!Files.isDirectory(srcDir.resolve(".git"), new LinkOption[0]) && (parent = srcDir.getParent()) != null) {
            srcDir = parent;
        }
        Path dstDir = this.target.toPath();
        try {
            Files.createDirectories(dstDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directory " + this.target, (Exception)e);
        }
        for (String glob : this.globs) {
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(srcDir, glob);
                try {
                    for (Path src : dirStream) {
                        if (!Files.isRegularFile(src, LinkOption.NOFOLLOW_LINKS)) continue;
                        Files.copy(src, dstDir.resolve(src.getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to perform filesystem operation", (Exception)e);
            }
        }
    }
}

