/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.base.Preconditions;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.netconf.shaded.sshd.server.auth.AsyncAuthException;
import org.opendaylight.netconf.shaded.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

final class UserPublicKeyAuthenticator
implements HostBasedAuthenticator,
PublickeyAuthenticator {
    private final Map<String, List<PublicKey>> userHostPublicKeyMap;

    UserPublicKeyAuthenticator(Map<String, List<PublicKey>> userHostPublicKeyMap) {
        Objects.requireNonNull(userHostPublicKeyMap);
        Preconditions.checkArgument((!userHostPublicKeyMap.isEmpty() ? 1 : 0) != 0, (Object)"userHostPublicKeyMap should not be empty");
        this.userHostPublicKeyMap = userHostPublicKeyMap;
    }

    public boolean authenticate(ServerSession serverSession, String username, PublicKey clientHostKey, String clientHostName, String clientUsername, List<X509Certificate> certificates) {
        return this.userHasMatchingKey(username, clientHostKey);
    }

    public boolean authenticate(String username, PublicKey publicKey, ServerSession serverSession) throws AsyncAuthException {
        return this.userHasMatchingKey(username, publicKey);
    }

    private boolean userHasMatchingKey(String username, PublicKey publicKey) {
        return Optional.ofNullable(this.userHostPublicKeyMap.get(username)).map(userKeys -> userKeys.contains(publicKey)).orElse(false);
    }
}

