/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.DoNotCall;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelFactory;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceFactoryFactory;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProvider;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactoryFactory;
import org.opendaylight.netconf.shaded.sshd.server.ServerBuilder;
import org.opendaylight.netconf.shaded.sshd.server.ServerFactoryManager;
import org.opendaylight.netconf.shaded.sshd.server.SshServer;
import org.opendaylight.netconf.shaded.sshd.server.auth.hostbased.UserAuthHostBasedFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.UserAuthPasswordFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.shaded.sshd.server.forward.DirectTcpipFactory;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.ConfigUtils;
import org.opendaylight.netconf.transport.ssh.CryptHashPasswordAuthenticator;
import org.opendaylight.netconf.transport.ssh.ServerFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.ssh.TransportChannelSessionFactory;
import org.opendaylight.netconf.transport.ssh.TransportServerSessionFactory;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.opendaylight.netconf.transport.ssh.UserPublicKeyAuthenticator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.crypt.hash.rev140806.CryptHash;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.TransportParamsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.SshServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.ClientAuthentication;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.Keepalives;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.ServerIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.client.authentication.Users;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.client.authentication.users.User;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.client.authentication.users.UserKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.client.authentication.users.user.Hostbased;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.client.authentication.users.user.PublicKeys;

final class TransportSshServer
extends SshServer {
    private TransportSshServer() {
    }

    @Deprecated(forRemoval=true)
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public void stop() {
        throw new UnsupportedOperationException();
    }

    static final class Builder
    extends ServerBuilder {
        private static final List<ChannelFactory> CHANNEL_FACTORIES = List.of(TransportChannelSessionFactory.INSTANCE, DirectTcpipFactory.INSTANCE);
        private final NettyIoServiceFactoryFactory ioServiceFactory;
        private final ScheduledExecutorService executorService;
        private ServerFactoryManagerConfigurator configurator;
        private ClientAuthentication clientAuthentication;
        private ServerIdentity serverIdentity;
        private Keepalives keepAlives;

        Builder(NettyIoServiceFactoryFactory ioServiceFactory, ScheduledExecutorService executorService) {
            this.ioServiceFactory = Objects.requireNonNull(ioServiceFactory);
            this.executorService = Objects.requireNonNull(executorService);
        }

        Builder serverParams(SshServerGrouping serverParams) throws UnsupportedConfigurationException {
            if (serverParams != null) {
                ConfigUtils.setTransportParams(this, (TransportParamsGrouping)serverParams.getTransportParams(), TransportUtils::getServerKexFactories);
                this.keepAlives = serverParams.getKeepalives();
                this.serverIdentity = serverParams.getServerIdentity();
                if (this.serverIdentity == null) {
                    throw new UnsupportedConfigurationException("Server identity configuration is required");
                }
                this.clientAuthentication = serverParams.getClientAuthentication();
            }
            return this;
        }

        Builder configurator(ServerFactoryManagerConfigurator newConfigurator) {
            this.configurator = newConfigurator;
            return this;
        }

        @Deprecated(forRemoval=true)
        @DoNotCall(value="Always throws UnsupportedOperationException")
        public TransportSshServer build() {
            throw new UnsupportedOperationException();
        }

        @Deprecated(forRemoval=true)
        @DoNotCall(value="Always throws UnsupportedOperationException")
        public TransportSshServer build(boolean isFillWithDefaultValues) {
            throw new UnsupportedOperationException();
        }

        TransportSshServer buildChecked() throws UnsupportedConfigurationException {
            TransportSshServer ret = (TransportSshServer)super.build(true);
            if (this.keepAlives != null) {
                ConfigUtils.setKeepAlives((FactoryManager)ret, this.keepAlives.getMaxWait(), this.keepAlives.getMaxAttempts());
            } else {
                ConfigUtils.setKeepAlives((FactoryManager)ret, null, null);
            }
            if (this.serverIdentity != null) {
                Builder.setServerIdentity(ret, this.serverIdentity);
            }
            if (this.clientAuthentication != null) {
                Builder.setClientAuthentication(ret, this.clientAuthentication);
            }
            if (this.configurator != null) {
                this.configurator.configureServerFactoryManager((ServerFactoryManager)ret);
            }
            ret.setIoServiceFactoryFactory((IoServiceFactoryFactory)this.ioServiceFactory);
            ret.setScheduledExecutorService(this.executorService);
            try {
                ret.checkConfig();
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedConfigurationException("Inconsistent client configuration", (Throwable)e);
            }
            ret.setSessionFactory(new TransportServerSessionFactory(ret));
            return ret;
        }

        protected ServerBuilder fillWithDefaultValues() {
            if (this.channelFactories == null) {
                this.channelFactories = CHANNEL_FACTORIES;
            }
            if (this.factory == null) {
                this.factory = TransportSshServer::new;
            }
            return super.fillWithDefaultValues();
        }

        private static void setServerIdentity(TransportSshServer server, ServerIdentity serverIdentity) throws UnsupportedConfigurationException {
            List hostKey = serverIdentity.getHostKey();
            if (hostKey == null || hostKey.isEmpty()) {
                throw new UnsupportedConfigurationException("Host keys is missing in server identity configuration");
            }
            List<KeyPair> serverHostKeyPairs = ConfigUtils.extractServerHostKeys(hostKey);
            if (!serverHostKeyPairs.isEmpty()) {
                server.setKeyPairProvider(KeyPairProvider.wrap(serverHostKeyPairs));
            }
        }

        private static void setClientAuthentication(TransportSshServer server, ClientAuthentication clientAuthentication) throws UnsupportedConfigurationException {
            Users users = clientAuthentication.getUsers();
            if (users == null) {
                return;
            }
            Map userMap = users.getUser();
            if (userMap != null) {
                ImmutableMap publicKeyMap;
                ImmutableMap hostBasedMap;
                ImmutableMap.Builder passwordMapBuilder = ImmutableMap.builder();
                ImmutableMap.Builder hostBasedMapBuilder = ImmutableMap.builder();
                ImmutableMap.Builder publicKeyMapBuilder = ImmutableMap.builder();
                for (Map.Entry entry : userMap.entrySet()) {
                    PublicKeys publicKey;
                    Hostbased hostBased;
                    String username = ((UserKey)entry.getKey()).getName();
                    User value = (User)entry.getValue();
                    CryptHash password = value.nonnullPassword().getHashedPassword();
                    if (password != null) {
                        passwordMapBuilder.put((Object)username, (Object)password.getValue());
                    }
                    if ((hostBased = value.getHostbased()) != null) {
                        hostBasedMapBuilder.put((Object)username, ConfigUtils.extractPublicKeys(hostBased.getInlineOrTruststore()));
                    }
                    if ((publicKey = value.getPublicKeys()) == null) continue;
                    publicKeyMapBuilder.put((Object)username, ConfigUtils.extractPublicKeys(publicKey.getInlineOrTruststore()));
                }
                ImmutableList.Builder authFactoriesBuilder = ImmutableList.builder();
                ImmutableMap passwordMap = passwordMapBuilder.build();
                if (!passwordMap.isEmpty()) {
                    authFactoriesBuilder.add((Object)new UserAuthPasswordFactory());
                    server.setPasswordAuthenticator(new CryptHashPasswordAuthenticator((Map<String, String>)passwordMap));
                }
                if (!(hostBasedMap = hostBasedMapBuilder.build()).isEmpty()) {
                    UserAuthHostBasedFactory factory = new UserAuthHostBasedFactory();
                    factory.setSignatureFactories(server.getSignatureFactories());
                    authFactoriesBuilder.add((Object)factory);
                    server.setHostBasedAuthenticator(new UserPublicKeyAuthenticator((Map<String, List<PublicKey>>)hostBasedMap));
                }
                if (!(publicKeyMap = publicKeyMapBuilder.build()).isEmpty()) {
                    UserAuthPublicKeyFactory factory = new UserAuthPublicKeyFactory();
                    factory.setSignatureFactories(server.getSignatureFactories());
                    authFactoriesBuilder.add((Object)factory);
                    server.setPublickeyAuthenticator(new UserPublicKeyAuthenticator((Map<String, List<PublicKey>>)publicKeyMap));
                }
                server.setUserAuthFactories((List)authFactoriesBuilder.build());
            }
        }
    }
}

