/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.shaded.sshd.common.io.IoSession;
import org.opendaylight.netconf.shaded.sshd.server.ServerFactoryManager;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSessionImpl;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.ssh.TransportServerSubsystem;
import org.opendaylight.netconf.transport.ssh.TransportSshServer;

final class TransportServerSession
extends ServerSessionImpl {
    private static final VarHandle STATE;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile State state;

    TransportServerSession(TransportSshServer server, IoSession ioSession) throws Exception {
        super((ServerFactoryManager)server, ioSession);
    }

    ListenableFuture<ChannelHandlerContext> attachUnderlay(String subsystem, TransportChannel underlay) {
        State newState = new State(subsystem, underlay, (SettableFuture<ChannelHandlerContext>)SettableFuture.create());
        Object witness = STATE.compareAndExchange(this, null, newState);
        if (witness != null) {
            throw new IllegalStateException("Already set up for " + String.valueOf(witness));
        }
        return newState.future;
    }

    @Nullable TransportServerSubsystem openSubsystem(String subsystem) {
        State local = STATE.getAndSet(this, null);
        if (local != null) {
            if (subsystem.equals(local.subsystem)) {
                return new TransportServerSubsystem(subsystem, local.underlay, local.future);
            }
            local.future.setException((Throwable)new IOException("Mismatched subsystem " + subsystem));
        }
        return null;
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(TransportServerSession.class, "state", State.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private record State(String subsystem, TransportChannel underlay, SettableFuture<ChannelHandlerContext> future) {
        State {
            subsystem = Objects.requireNonNull(subsystem);
            underlay = Objects.requireNonNull(underlay);
            future = Objects.requireNonNull(future);
        }
    }
}

