/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.DoNotCall;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.opendaylight.netconf.shaded.sshd.client.channel.ChannelSubsystem;
import org.opendaylight.netconf.shaded.sshd.client.future.OpenFuture;
import org.opendaylight.netconf.shaded.sshd.common.channel.StreamingChannel;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransportClientSubsystem
extends ChannelSubsystem {
    private static final Logger LOG = LoggerFactory.getLogger(TransportClientSubsystem.class);
    private ChannelHandlerContext head;

    TransportClientSubsystem(String subsystem) {
        super(subsystem);
        this.setStreaming(StreamingChannel.Streaming.Async);
    }

    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public OpenFuture open() throws IOException {
        throw new UnsupportedOperationException();
    }

    synchronized ListenableFuture<ChannelHandlerContext> open(TransportChannel underlay) throws IOException {
        LOG.debug("Opening client subsystem \"{}\"", (Object)this.getSubsystem());
        SettableFuture ret = SettableFuture.create();
        super.open().addListener(future -> {
            if (future.isOpened()) {
                this.head = TransportUtils.attachUnderlay(this.getAsyncIn(), underlay, () -> ((TransportClientSubsystem)this).close());
                ret.set((Object)this.head);
            } else {
                Throwable ex = future.getException();
                LOG.debug("Failed to open client subsystem \"{}\"", (Object)this.getSubsystem(), (Object)ex);
                ret.setException(ex);
            }
        });
        return ret;
    }

    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        int reqLen = (int)len;
        if (reqLen > 0) {
            LOG.debug("Forwarding {} bytes of data", (Object)reqLen);
            this.head.fireChannelRead((Object)Unpooled.copiedBuffer((byte[])data, (int)off, (int)reqLen));
            this.getLocalWindow().release((long)reqLen);
        }
    }

    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        LOG.debug("Discarding {} bytes of extended data", (Object)len);
        if (len > 0L) {
            this.getLocalWindow().release(len);
        }
    }
}

