/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import java.io.IOException;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSession;
import org.opendaylight.netconf.transport.ssh.TransportServerSession;
import org.opendaylight.netconf.transport.ssh.TransportServerSubsystem;

final class TransportChannelSession
extends ChannelSession {
    private final TransportServerSession serverSession;

    TransportChannelSession(TransportServerSession serverSession) {
        this.serverSession = Objects.requireNonNull(serverSession);
    }

    protected RequestHandler.Result handleSubsystemParsed(String request, String subsystem) throws IOException {
        TransportServerSubsystem openSubsystem = this.serverSession.openSubsystem(subsystem);
        if (openSubsystem == null) {
            this.log.warn("handleSubsystemParsed({}) Unsupported subsystem: {}", (Object)this, (Object)subsystem);
            return RequestHandler.Result.ReplyFailure;
        }
        this.commandInstance = openSubsystem;
        RequestHandler.Result prepareResult = this.prepareChannelCommand(request, this.commandInstance);
        if (prepareResult == RequestHandler.Result.ReplySuccess) {
            openSubsystem.onPrepareComplete();
        }
        return prepareResult;
    }
}

