/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactoryFactory;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.ssh.SSHClient;
import org.opendaylight.netconf.transport.ssh.SSHServer;
import org.opendaylight.netconf.transport.ssh.SSHTransportChannel;
import org.opendaylight.netconf.transport.ssh.ServerFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.tcp.BootstrapFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.SshServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;

public final class SSHTransportStackFactory
extends BootstrapFactory {
    private final NettyIoServiceFactoryFactory ioServiceFactory;

    public SSHTransportStackFactory(@NonNull String groupName, int groupThreads) {
        super(groupName, groupThreads);
        this.ioServiceFactory = new NettyIoServiceFactoryFactory(this.group);
    }

    public SSHTransportStackFactory(@NonNull String groupName, int groupThreads, @NonNull String parentGroupName, int parentGroupThreads) {
        super(groupName, groupThreads, parentGroupName, parentGroupThreads);
        this.ioServiceFactory = new NettyIoServiceFactoryFactory(this.group);
    }

    public @NonNull ListenableFuture<SSHClient> connectClient(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpClientGrouping connectParams, SshClientGrouping clientParams) throws UnsupportedConfigurationException {
        return SSHClient.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, clientParams, null).connect(this.newBootstrap(), connectParams);
    }

    public @NonNull ListenableFuture<SSHClient> connectClient(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpClientGrouping connectParams, SshClientGrouping clientParams, ClientFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        return SSHClient.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, clientParams, configurator).connect(this.newBootstrap(), connectParams);
    }

    public @NonNull ListenableFuture<SSHClient> listenClient(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpServerGrouping listenParams, SshClientGrouping clientParams) throws UnsupportedConfigurationException {
        return SSHClient.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, clientParams, null).listen(this.newServerBootstrap(), listenParams);
    }

    public @NonNull ListenableFuture<SSHClient> listenClient(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpServerGrouping listenParams, SshClientGrouping clientParams, ClientFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        return SSHClient.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, clientParams, configurator).listen(this.newServerBootstrap(), listenParams);
    }

    public @NonNull ListenableFuture<SSHServer> connectServer(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpClientGrouping connectParams, SshServerGrouping serverParams) throws UnsupportedConfigurationException {
        return SSHServer.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, Objects.requireNonNull(serverParams), null).connect(this.newBootstrap(), connectParams);
    }

    public @NonNull ListenableFuture<SSHServer> connectServer(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpClientGrouping connectParams, SshServerGrouping serverParams, ServerFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        Preconditions.checkArgument((serverParams != null || configurator != null ? 1 : 0) != 0, (Object)"Neither server parameters nor factory configurator is defined");
        return SSHServer.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, serverParams, configurator).connect(this.newBootstrap(), connectParams);
    }

    public @NonNull ListenableFuture<SSHServer> listenServer(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpServerGrouping connectParams, SshServerGrouping serverParams) throws UnsupportedConfigurationException {
        return this.listenServer(subsystem, listener, connectParams, Objects.requireNonNull(serverParams), null);
    }

    public @NonNull ListenableFuture<SSHServer> listenServer(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TcpServerGrouping listenParams, SshServerGrouping serverParams, ServerFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        Preconditions.checkArgument((serverParams != null || configurator != null ? 1 : 0) != 0, (Object)"Neither server parameters nor factory configurator is defined");
        return SSHServer.of(this.ioServiceFactory, (ScheduledExecutorService)this.group, subsystem, listener, serverParams, configurator).listen(this.newServerBootstrap(), listenParams);
    }
}

