/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactoryFactory;
import org.opendaylight.netconf.transport.api.AbstractOverlayTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.SSHTransportChannel;
import org.opendaylight.netconf.transport.ssh.SSHTransportStack;
import org.opendaylight.netconf.transport.ssh.ServerFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.ssh.TransportServerSession;
import org.opendaylight.netconf.transport.ssh.TransportSshServer;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.opendaylight.netconf.transport.tcp.TCPClient;
import org.opendaylight.netconf.transport.tcp.TCPServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.SshServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSHServer
extends SSHTransportStack {
    private static final Logger LOG = LoggerFactory.getLogger(SSHServer.class);
    private final String subsystem;

    private SSHServer(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TransportSshServer sshServer) {
        super(listener, (FactoryManager)sshServer, (IoHandler)sshServer.getSessionFactory());
        this.subsystem = Objects.requireNonNull(subsystem);
    }

    static SSHServer of(NettyIoServiceFactoryFactory ioServiceFactory, ScheduledExecutorService executorService, String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, SshServerGrouping serverParams, ServerFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        return new SSHServer(subsystem, listener, new TransportSshServer.Builder(ioServiceFactory, executorService).serverParams(serverParams).configurator(configurator).buildChecked());
    }

    @NonNull ListenableFuture<SSHServer> connect(Bootstrap bootstrap, TcpClientGrouping connectParams) throws UnsupportedConfigurationException {
        return SSHServer.transformUnderlay((AbstractOverlayTransportStack)this, (ListenableFuture)TCPClient.connect((TransportChannelListener)this.asListener(), (Bootstrap)bootstrap, (TcpClientGrouping)connectParams));
    }

    @NonNull ListenableFuture<SSHServer> listen(ServerBootstrap bootstrap, TcpServerGrouping connectParams) throws UnsupportedConfigurationException {
        return SSHServer.transformUnderlay((AbstractOverlayTransportStack)this, (ListenableFuture)TCPServer.listen((TransportChannelListener)this.asListener(), (ServerBootstrap)bootstrap, (TcpServerGrouping)connectParams));
    }

    @Override
    void onKeyEstablished(Session session) {
    }

    @Override
    void onAuthenticated(Session session) throws IOException {
        final Long sessionId = SSHServer.sessionId(session);
        LOG.debug("Awaiting \"{}\" subsystem on session {}", (Object)this.subsystem, (Object)sessionId);
        Futures.addCallback(SSHServer.cast(session).attachUnderlay(this.subsystem, this.getUnderlayOf(sessionId)), (FutureCallback)new FutureCallback<ChannelHandlerContext>(){

            public void onSuccess(ChannelHandlerContext result) {
                LOG.debug("Established \"{}\" subsystem on session {}", (Object)SSHServer.this.subsystem, (Object)sessionId);
                SSHServer.this.transportEstablished(sessionId, result);
            }

            public void onFailure(Throwable cause) {
                LOG.debug("Binding to \"{}\" subsystem on session {} failed", new Object[]{SSHServer.this.subsystem, sessionId, cause});
                SSHServer.this.transportFailed(sessionId, cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static TransportServerSession cast(Session session) throws IOException {
        return TransportUtils.checkCast(TransportServerSession.class, session);
    }
}

