/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelAsyncOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.io.IoWriteFuture;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.shaded.sshd.common.util.io.functors.IOFunction;
import org.opendaylight.netconf.shaded.sshd.common.util.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutboundChannelHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundChannelHandler.class);
    private final IOFunction<Buffer, IoWriteFuture> outWriteBuffer = arg_0 -> ((ChannelAsyncOutputStream)Objects.requireNonNull(out)).writeBuffer(arg_0);
    private ArrayDeque<Write> pending;
    private boolean writePending;

    OutboundChannelHandler(ChannelAsyncOutputStream out) {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.write(buf, promise);
        } else {
            LOG.trace("Ignoring unrecognized {}", msg == null ? null : msg.getClass());
        }
    }

    private void write(ByteBuf buf, ChannelPromise promise) {
        if (this.writePending) {
            LOG.trace("A write is already pending, delaying write");
            this.delayWrite(buf, promise);
        } else {
            LOG.trace("Issuing immediate write");
            this.startWrite(buf, promise);
        }
    }

    private void delayWrite(ByteBuf buf, ChannelPromise promise) {
        if (this.pending == null) {
            this.pending = new ArrayDeque(1);
        }
        this.pending.addLast(new Write(buf, promise));
    }

    private void startWrite(ByteBuf buf, ChannelPromise promise) {
        IoWriteFuture writeFuture;
        ByteArrayBuffer sshBuf = OutboundChannelHandler.toSshBuffer(buf);
        try {
            writeFuture = (IoWriteFuture)ThreadUtils.runAsInternal((Object)sshBuf, this.outWriteBuffer);
        }
        catch (IOException e) {
            this.failWrites(promise, e);
            return;
        }
        this.writePending = true;
        writeFuture.addListener(future -> this.finishWrite((IoWriteFuture)future, promise));
    }

    private void finishWrite(IoWriteFuture future, ChannelPromise promise) {
        this.writePending = false;
        if (future.isWritten()) {
            Write next;
            promise.setSuccess();
            if (this.pending != null && (next = this.pending.pollFirst()) != null) {
                LOG.trace("Issuing next write");
                this.startWrite(next.buf, next.promise);
            }
            return;
        }
        Throwable cause = future.getException();
        if (cause != null) {
            this.failWrites(promise, cause);
        }
    }

    private void failWrites(ChannelPromise promise, Throwable cause) {
        LOG.error("Error writing buffer", cause);
        promise.setFailure(cause);
        if (this.pending != null) {
            this.pending.forEach(msg -> msg.promise.setFailure(cause));
            this.pending = null;
        }
    }

    private static ByteArrayBuffer toSshBuffer(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        byteBuf.release();
        return new ByteArrayBuffer(bytes);
    }

    private record Write(ByteBuf buf, ChannelPromise promise) {
        Write {
            Objects.requireNonNull(buf);
            Objects.requireNonNull(promise);
        }
    }
}

