/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.Crypt;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.PasswordAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

final class CryptHashPasswordAuthenticator
implements PasswordAuthenticator {
    private static final Pattern CRYPT_HASH_PATTERN = Pattern.compile("\\$0\\$.*|\\$1\\$[a-zA-Z0-9./]{1,8}\\$[a-zA-Z0-9./]{22}|\\$5\\$(rounds=\\d+\\$)?[a-zA-Z0-9./]{1,16}\\$[a-zA-Z0-9./]{43}|\\$6\\$(rounds=\\d+\\$)?[a-zA-Z0-9./]{1,16}\\$[a-zA-Z0-9./]{86}");
    private static final String DEFAULT_SALT = "$5$rounds=3500$default";
    private final ImmutableMap<String, CryptHash> knownHashes;

    CryptHashPasswordAuthenticator(Map<String, String> userHashes) {
        if (userHashes.isEmpty()) {
            throw new IllegalArgumentException("Hashes map should not be empty");
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : userHashes.entrySet()) {
            String hash = entry.getValue();
            if (!CRYPT_HASH_PATTERN.matcher(hash).matches()) {
                throw new IllegalArgumentException("Invalid crypt hash string \"" + hash + "\"");
            }
            mapBuilder.put((Object)entry.getKey(), (Object)(hash.startsWith("$0$") ? new CryptHash(DEFAULT_SALT, Crypt.crypt((String)hash.substring(3), (String)DEFAULT_SALT)) : new CryptHash(hash.substring(0, hash.lastIndexOf(36)), hash)));
        }
        this.knownHashes = mapBuilder.build();
    }

    public boolean authenticate(String username, String password, ServerSession serverSession) {
        CryptHash found = (CryptHash)this.knownHashes.get((Object)username);
        return found != null && found.hash.equals(Crypt.crypt((String)password, (String)found.salt));
    }

    private record CryptHash(String salt, String hash) {
        CryptHash {
            Objects.requireNonNull(salt);
            Objects.requireNonNull(hash);
        }
    }
}

