/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.shaded.sshd.common.BaseBuilder;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchangeFactory;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionHeartbeatController;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.KeyUtils;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.AsymmetricKeyPairGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.EcPrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.PrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.PublicKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.RsaPrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.SshPublicKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.SubjectPublicKeyInfoFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010._private.key.grouping.PrivateKeyType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010._private.key.grouping._private.key.type.CleartextPrivateKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.InlineOrKeystoreEndEntityCertWithKeyGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.asymmetric.key.grouping.InlineOrKeystore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.asymmetric.key.grouping.inline.or.keystore.Inline;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.server.authentication.SshHostKeys;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.TransportParamsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.transport.params.grouping.KeyExchange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.HostKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.HostKeyType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.InlineOrTruststoreCertsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.InlineOrTruststore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.inline.or.truststore.inline.InlineDefinition;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

final class ConfigUtils {
    private static final int KEEP_ALIVE_DEFAULT_MAX_WAIT = 30;
    private static final int KEEP_ALIVE_DEFAULT_ATTEMPTS = 3;

    private ConfigUtils() {
    }

    static void setTransportParams(@NonNull BaseBuilder<?, ?> builder, @Nullable TransportParamsGrouping params, @NonNull KexFactoryProvider kexProvider) throws UnsupportedConfigurationException {
        builder.cipherFactories(TransportUtils.getCipherFactories(params == null ? null : params.getEncryption())).signatureFactories(TransportUtils.getSignatureFactories(params == null ? null : params.getHostKey())).keyExchangeFactories(kexProvider.getKexFactories(params == null ? null : params.getKeyExchange())).macFactories(TransportUtils.getMacFactories(params == null ? null : params.getMac()));
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="maxAttempts usage need clarification")
    static void setKeepAlives(@NonNull FactoryManager factoryMgr, @Nullable Uint16 cfgMaxWait, @Nullable Uint8 cfgMaxAttempts) {
        int maxAttempts = cfgMaxAttempts == null ? 3 : cfgMaxAttempts.intValue();
        int maxWait = cfgMaxWait == null ? 30 : cfgMaxWait.intValue();
        factoryMgr.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, Duration.ofSeconds(maxWait));
    }

    static List<KeyPair> extractServerHostKeys(List<HostKey> serverHostKeys) throws UnsupportedConfigurationException {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (HostKey hostKey : serverHostKeys) {
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.Certificate certificate;
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.PublicKey publicKey;
            HostKeyType hostKeyType = hostKey.getHostKeyType();
            if (hostKeyType instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.PublicKey && (publicKey = (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.PublicKey)hostKeyType).getPublicKey() != null) {
                listBuilder.add((Object)ConfigUtils.extractKeyPair(publicKey.getPublicKey().getInlineOrKeystore()));
                continue;
            }
            hostKeyType = hostKey.getHostKeyType();
            if (!(hostKeyType instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.Certificate) || (certificate = (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.server.rev241010.ssh.server.grouping.server.identity.host.key.host.key.type.Certificate)hostKeyType).getCertificate() == null) continue;
            listBuilder.add((Object)ConfigUtils.extractCertificateEntry((InlineOrKeystoreEndEntityCertWithKeyGrouping)certificate.getCertificate()).getKey());
        }
        return listBuilder.build();
    }

    static KeyPair extractKeyPair(InlineOrKeystore input) throws UnsupportedConfigurationException {
        Inline inline = ConfigUtils.ofType(Inline.class, input);
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.asymmetric.key.grouping.inline.or.keystore.inline.InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        return ConfigUtils.extractKeyPair((AsymmetricKeyPairGrouping)inlineDef);
    }

    private static KeyPair extractKeyPair(AsymmetricKeyPairGrouping input) throws UnsupportedConfigurationException {
        boolean isSshPublicKey;
        String privateKeyAlgorithm;
        PrivateKeyFormat keyFormat = input.getPrivateKeyFormat();
        if (EcPrivateKeyFormat.VALUE.equals((Object)keyFormat)) {
            privateKeyAlgorithm = "EC";
        } else if (RsaPrivateKeyFormat.VALUE.equals((Object)input.getPrivateKeyFormat())) {
            privateKeyAlgorithm = "RSA";
        } else {
            throw new UnsupportedConfigurationException("Unsupported private key format " + String.valueOf(keyFormat));
        }
        PrivateKeyType privateKeyType = input.getPrivateKeyType();
        if (!(privateKeyType instanceof CleartextPrivateKey)) {
            throw new UnsupportedConfigurationException("Unsupported private key type " + String.valueOf(input.getPrivateKeyType()));
        }
        CleartextPrivateKey clearText = (CleartextPrivateKey)privateKeyType;
        byte[] privateKeyBytes = clearText.requireCleartextPrivateKey();
        PublicKeyFormat publicKeyFormat = input.getPublicKeyFormat();
        byte[] publicKeyBytes = input.getPublicKey();
        if (SubjectPublicKeyInfoFormat.VALUE.equals((Object)publicKeyFormat)) {
            isSshPublicKey = false;
        } else if (SshPublicKeyFormat.VALUE.equals((Object)publicKeyFormat)) {
            isSshPublicKey = true;
        } else {
            throw new UnsupportedConfigurationException("Unsupported public key format " + String.valueOf(publicKeyFormat));
        }
        PrivateKey privateKey = KeyUtils.buildPrivateKey(privateKeyAlgorithm, privateKeyBytes);
        PublicKey publicKey = isSshPublicKey ? KeyUtils.buildPublicKeyFromSshEncoding(publicKeyBytes) : KeyUtils.buildX509PublicKey(privateKeyAlgorithm, publicKeyBytes);
        KeyUtils.validateKeyPair(publicKey, privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    static List<Certificate> extractCertificates(@Nullable InlineOrTruststoreCertsGrouping input) throws UnsupportedConfigurationException {
        if (input == null) {
            return List.of();
        }
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.Inline inline = ConfigUtils.ofType(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.Inline.class, input.getInlineOrTruststore());
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.inline.InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.inline.inline.definition.Certificate cert : inlineDef.nonnullCertificate().values()) {
            listBuilder.add((Object)KeyUtils.buildX509Certificate(cert.requireCertData().getValue()));
        }
        return listBuilder.build();
    }

    private static Map.Entry<KeyPair, List<X509Certificate>> extractCertificateEntry(InlineOrKeystoreEndEntityCertWithKeyGrouping input) throws UnsupportedConfigurationException {
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.Inline inline = ConfigUtils.ofType(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.Inline.class, input.getInlineOrKeystore());
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.inline.InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        KeyPair keyPair = ConfigUtils.extractKeyPair((AsymmetricKeyPairGrouping)inlineDef);
        X509Certificate certificate = KeyUtils.buildX509Certificate(inlineDef.requireCertData().getValue());
        KeyUtils.validatePublicKey(keyPair.getPublic(), certificate);
        return new AbstractMap.SimpleImmutableEntry<KeyPair, List<X509Certificate>>(keyPair, List.of(certificate));
    }

    private static <T> T ofType(Class<T> expectedType, Object obj) throws UnsupportedConfigurationException {
        if (!expectedType.isInstance(obj)) {
            throw new UnsupportedConfigurationException("Expected type: " + String.valueOf(expectedType) + " actual: " + String.valueOf(obj.getClass()));
        }
        return expectedType.cast(obj);
    }

    static List<PublicKey> extractPublicKeys(InlineOrTruststore input) throws UnsupportedConfigurationException {
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.inline.or.truststore.Inline inline = ConfigUtils.ofType(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.inline.or.truststore.Inline.class, input);
        InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        Map publicKey = inlineDef.getPublicKey();
        if (publicKey == null) {
            return List.of();
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Map.Entry entry : publicKey.entrySet()) {
            if (!SshPublicKeyFormat.VALUE.equals((Object)((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.inline.or.truststore.inline.inline.definition.PublicKey)entry.getValue()).getPublicKeyFormat())) {
                throw new UnsupportedConfigurationException("ssh public key format is expected");
            }
            listBuilder.add((Object)KeyUtils.buildPublicKeyFromSshEncoding(((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore._public.keys.grouping.inline.or.truststore.inline.inline.definition.PublicKey)entry.getValue()).getPublicKey()));
        }
        return listBuilder.build();
    }

    static List<PublicKey> extractPublicKeys(@Nullable SshHostKeys sshHostKeys) throws UnsupportedConfigurationException {
        return sshHostKeys == null ? List.of() : ConfigUtils.extractPublicKeys(sshHostKeys.getInlineOrTruststore());
    }

    @FunctionalInterface
    static interface KexFactoryProvider {
        public List<KeyExchangeFactory> getKexFactories(KeyExchange var1) throws UnsupportedConfigurationException;
    }
}

