/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@Beta
@NonNullByDefault
public final class TcpMd5Secrets {
    private static final TcpMd5Secrets EMPTY = new TcpMd5Secrets((ImmutableMap<InetAddress, ByteBuf>)ImmutableMap.of());
    private final ImmutableMap<InetAddress, ByteBuf> map;

    private TcpMd5Secrets(ImmutableMap<InetAddress, ByteBuf> map) {
        this.map = Objects.requireNonNull(map);
    }

    public static TcpMd5Secrets of() {
        return EMPTY;
    }

    public static TcpMd5Secrets of(InetAddress inetAddress, byte[] key) {
        return new TcpMd5Secrets((ImmutableMap<InetAddress, ByteBuf>)ImmutableMap.of((Object)inetAddress, (Object)Unpooled.wrappedBuffer((byte[])((byte[])key.clone()))));
    }

    public static TcpMd5Secrets of(InetAddress inetAddress, ByteBuf key) {
        return new TcpMd5Secrets((ImmutableMap<InetAddress, ByteBuf>)ImmutableMap.of((Object)inetAddress, (Object)key.copy().asReadOnly()));
    }

    public static TcpMd5Secrets of(InetAddress inetAddress, String password) throws CharacterCodingException {
        return new TcpMd5Secrets((ImmutableMap<InetAddress, ByteBuf>)ImmutableMap.of((Object)inetAddress, (Object)TcpMd5Secrets.asciiBytes(password)));
    }

    public static TcpMd5Secrets of(Map<InetAddress, String> passwords) throws CharacterCodingException {
        int size = passwords.size();
        return switch (size) {
            case 0 -> TcpMd5Secrets.of();
            case 1 -> {
                Map.Entry<InetAddress, String> entry = passwords.entrySet().iterator().next();
                yield TcpMd5Secrets.of(entry.getKey(), entry.getValue());
            }
            default -> {
                Builder builder = TcpMd5Secrets.builder();
                for (Map.Entry<InetAddress, String> entry : passwords.entrySet()) {
                    builder.put(entry.getKey(), entry.getValue());
                }
                yield builder.build();
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<InetAddress, ByteBuf> asMap() {
        return Maps.transformValues(this.map, ByteBuf::slice);
    }

    Map<InetAddress, byte[]> toOption() {
        return Maps.transformValues(this.map, ByteBufUtil::getBytes);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TcpMd5Secrets)) return false;
        TcpMd5Secrets other = (TcpMd5Secrets)obj;
        if (!this.map.equals(other.map)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", (Object)this.map.keySet()).toString();
    }

    private static ByteBuf asciiBytes(String str) throws CharacterCodingException {
        return Unpooled.copiedBuffer((ByteBuffer)StandardCharsets.US_ASCII.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).encode(CharBuffer.wrap(str))).asReadOnly();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<InetAddress, ByteBuf> builder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder put(InetAddress peer, byte[] key) {
            this.builder.put((Object)peer, (Object)Unpooled.wrappedBuffer((byte[])((byte[])key.clone())).asReadOnly());
            return this;
        }

        public Builder put(InetAddress peer, String asciiKey) throws CharacterCodingException {
            return this.put(peer, TcpMd5Secrets.asciiBytes(asciiKey));
        }

        public Builder put(InetAddress peer, ByteBuf key) {
            return this.putUnsafe(peer, key.copy());
        }

        public Builder putUnsafe(InetAddress peer, ByteBuf key) {
            this.builder.put((Object)peer, (Object)key.asReadOnly());
            return this;
        }

        public TcpMd5Secrets build() {
            ImmutableMap map = this.builder.buildKeepingLast();
            return map.isEmpty() ? EMPTY : new TcpMd5Secrets((ImmutableMap<InetAddress, ByteBuf>)map);
        }
    }
}

