/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.Objects;
import jdk.net.ExtendedSocketOptions;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.TcpMd5Secrets;

@NonNullByDefault
final class NioNettyImpl
extends NettyImpl {
    private static final NettyTcpKeepaliveOptions KEEPALIVE_OPTIONS = new NettyTcpKeepaliveOptions((ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPCOUNT), (ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPIDLE), (ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPINTERVAL));
    private static final boolean SUPPORTS_KEEPALIVES;
    private final IoHandlerFactory ioHandlerFactory = NioIoHandler.newFactory();
    private final Throwable epollCause;

    NioNettyImpl(Throwable epollCause) {
        this.epollCause = Objects.requireNonNull(epollCause);
    }

    Class<NioDatagramChannel> datagramChannelClass() {
        return NioDatagramChannel.class;
    }

    Class<NioSocketChannel> channelClass() {
        return NioSocketChannel.class;
    }

    Class<NioServerSocketChannel> serverChannelClass() {
        return NioServerSocketChannel.class;
    }

    @Override
    IoHandlerFactory ioHandlerFactory() {
        return this.ioHandlerFactory;
    }

    @Override
    @Nullable NettyTcpKeepaliveOptions keepaliveOptions() {
        return SUPPORTS_KEEPALIVES ? KEEPALIVE_OPTIONS : null;
    }

    @Override
    void setTcpMd5(AbstractBootstrap<?, ?> bootstrap, TcpMd5Secrets secrets) throws UnsupportedConfigurationException {
        Objects.requireNonNull(bootstrap);
        Objects.requireNonNull(secrets);
        throw this.uce();
    }

    @Override
    boolean setTcpMd5(Channel channel, TcpMd5Secrets secrets) throws UnsupportedConfigurationException {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(secrets);
        throw this.uce();
    }

    @Override
    public String toString() {
        return "java.nio " + (SUPPORTS_KEEPALIVES ? "with" : "without") + " TCP keepalive options";
    }

    private UnsupportedConfigurationException uce() {
        return new UnsupportedConfigurationException("TCP MD5 Signatures are not supported", this.epollCause.getCause());
    }

    static {
        MultiThreadIoEventLoopGroup grp = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            try {
                NioSocketChannel ch = new NioSocketChannel();
                grp.register((Channel)ch).sync();
                try {
                    SUPPORTS_KEEPALIVES = ch.config().setOptions(Map.of(ChannelOption.SO_KEEPALIVE, Boolean.TRUE, KEEPALIVE_OPTIONS.tcpKeepIdle(), 7200, KEEPALIVE_OPTIONS.tcpKeepCnt(), 3, KEEPALIVE_OPTIONS.tcpKeepIntvl(), 5));
                }
                finally {
                    ch.close().sync();
                }
            }
            finally {
                grp.shutdownGracefully().sync();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExceptionInInitializerError(e);
        }
    }
}

