/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.ConnectionOper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.DatastoreAccess;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.NetconfSchemaStorage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.AvailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.AvailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.ClusteredConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.ClusteredConnectionStatusBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.PassThrough;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.PassThroughBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.UnavailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.UnavailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.NonModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.NonModuleCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.OdlHelloMessageCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.OdlHelloMessageCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.ProtocolBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.YangModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.YangModuleCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.netconf.schema.storage.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.netconf.schema.storage.YangLibraryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class NetconfNodeBuilder {
    private Uint16 _actorResponseWaitTime;
    private AvailableCapabilities _availableCapabilities;
    private Decimal64 _backoffJitter;
    private Decimal64 _backoffMultiplier;
    private ClusteredConnectionStatus _clusteredConnectionStatus;
    private Uint16 _concurrentRpcLimit;
    private String _connectedMessage;
    private ConnectionOper.ConnectionStatus _connectionStatus;
    private Uint32 _connectionTimeoutMillis;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials _credentials;
    private Uint32 _defaultRequestTimeoutMillis;
    private Host _host;
    private Uint32 _keepaliveDelay;
    private Boolean _lockDatastore;
    private Uint32 _maxBackoffMillis;
    private Uint32 _maxConnectionAttempts;
    private Uint16 _minBackoffMillis;
    private NonModuleCapabilities _nonModuleCapabilities;
    private OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
    private PassThrough _passThrough;
    private PortNumber _port;
    private Protocol _protocol;
    private Boolean _reconnectOnChangedSchema;
    private String _schemaCacheDirectory;
    private Boolean _schemaless;
    private SessionIdType _sessionId;
    private Boolean _tcpOnly;
    private UnavailableCapabilities _unavailableCapabilities;
    private YangLibrary _yangLibrary;
    private YangModuleCapabilities _yangModuleCapabilities;
    Map<Class<? extends Augmentation<NetconfNode>>, Augmentation<NetconfNode>> augmentation = Map.of();
    private static final Range<Decimal64>[] CHECKBACKOFFJITTERRANGE_RANGES;
    private static final Range<Decimal64>[] CHECKBACKOFFMULTIPLIERRANGE_RANGES;

    public NetconfNodeBuilder() {
    }

    public NetconfNodeBuilder(Credentials arg) {
        this._credentials = arg.getCredentials();
    }

    public NetconfNodeBuilder(ConnectionParameters arg) {
        this._host = arg.getHost();
        this._port = arg.getPort();
        this._tcpOnly = arg.getTcpOnly();
        this._protocol = arg.getProtocol();
        this._schemaless = arg.getSchemaless();
        this._yangModuleCapabilities = arg.getYangModuleCapabilities();
        this._nonModuleCapabilities = arg.getNonModuleCapabilities();
        this._reconnectOnChangedSchema = arg.getReconnectOnChangedSchema();
        this._connectionTimeoutMillis = arg.getConnectionTimeoutMillis();
        this._defaultRequestTimeoutMillis = arg.getDefaultRequestTimeoutMillis();
        this._maxConnectionAttempts = arg.getMaxConnectionAttempts();
        this._minBackoffMillis = arg.getMinBackoffMillis();
        this._maxBackoffMillis = arg.getMaxBackoffMillis();
        this._backoffMultiplier = arg.getBackoffMultiplier();
        this._backoffJitter = arg.getBackoffJitter();
        this._keepaliveDelay = arg.getKeepaliveDelay();
        this._concurrentRpcLimit = arg.getConcurrentRpcLimit();
        this._actorResponseWaitTime = arg.getActorResponseWaitTime();
        this._odlHelloMessageCapabilities = arg.getOdlHelloMessageCapabilities();
    }

    public NetconfNodeBuilder(NetconfSchemaStorage arg) {
        this._schemaCacheDirectory = arg.getSchemaCacheDirectory();
        this._yangLibrary = arg.getYangLibrary();
    }

    public NetconfNodeBuilder(DatastoreAccess arg) {
        this._lockDatastore = arg.getLockDatastore();
    }

    public NetconfNodeBuilder(ConnectionOper arg) {
        this._sessionId = arg.getSessionId();
        this._connectionStatus = arg.getConnectionStatus();
        this._clusteredConnectionStatus = arg.getClusteredConnectionStatus();
        this._connectedMessage = arg.getConnectedMessage();
        this._availableCapabilities = arg.getAvailableCapabilities();
        this._unavailableCapabilities = arg.getUnavailableCapabilities();
        this._passThrough = arg.getPassThrough();
    }

    public NetconfNodeBuilder(NetconfNode base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfNode>>, Augmentation<NetconfNode>>(aug);
        }
        this._actorResponseWaitTime = base.getActorResponseWaitTime();
        this._availableCapabilities = base.getAvailableCapabilities();
        this._backoffJitter = base.getBackoffJitter();
        this._backoffMultiplier = base.getBackoffMultiplier();
        this._clusteredConnectionStatus = base.getClusteredConnectionStatus();
        this._concurrentRpcLimit = base.getConcurrentRpcLimit();
        this._connectedMessage = base.getConnectedMessage();
        this._connectionStatus = base.getConnectionStatus();
        this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
        this._credentials = base.getCredentials();
        this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
        this._host = base.getHost();
        this._keepaliveDelay = base.getKeepaliveDelay();
        this._lockDatastore = base.getLockDatastore();
        this._maxBackoffMillis = base.getMaxBackoffMillis();
        this._maxConnectionAttempts = base.getMaxConnectionAttempts();
        this._minBackoffMillis = base.getMinBackoffMillis();
        this._nonModuleCapabilities = base.getNonModuleCapabilities();
        this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
        this._passThrough = base.getPassThrough();
        this._port = base.getPort();
        this._protocol = base.getProtocol();
        this._reconnectOnChangedSchema = base.getReconnectOnChangedSchema();
        this._schemaCacheDirectory = base.getSchemaCacheDirectory();
        this._schemaless = base.getSchemaless();
        this._sessionId = base.getSessionId();
        this._tcpOnly = base.getTcpOnly();
        this._unavailableCapabilities = base.getUnavailableCapabilities();
        this._yangLibrary = base.getYangLibrary();
        this._yangModuleCapabilities = base.getYangModuleCapabilities();
    }

    public void fieldsFrom(Grouping arg) {
        Credentials castArg;
        boolean isValidArg = false;
        if (arg instanceof Credentials) {
            castArg = (Credentials)arg;
            this._credentials = castArg.getCredentials();
            isValidArg = true;
        }
        if (arg instanceof NetconfSchemaStorage) {
            castArg = (NetconfSchemaStorage)arg;
            this._schemaCacheDirectory = castArg.getSchemaCacheDirectory();
            this._yangLibrary = castArg.getYangLibrary();
            isValidArg = true;
        }
        if (arg instanceof ConnectionParameters) {
            castArg = (ConnectionParameters)arg;
            this._host = castArg.getHost();
            this._port = castArg.getPort();
            this._tcpOnly = castArg.getTcpOnly();
            this._protocol = castArg.getProtocol();
            this._schemaless = castArg.getSchemaless();
            this._yangModuleCapabilities = castArg.getYangModuleCapabilities();
            this._nonModuleCapabilities = castArg.getNonModuleCapabilities();
            this._reconnectOnChangedSchema = castArg.getReconnectOnChangedSchema();
            this._connectionTimeoutMillis = castArg.getConnectionTimeoutMillis();
            this._defaultRequestTimeoutMillis = castArg.getDefaultRequestTimeoutMillis();
            this._maxConnectionAttempts = castArg.getMaxConnectionAttempts();
            this._minBackoffMillis = castArg.getMinBackoffMillis();
            this._maxBackoffMillis = castArg.getMaxBackoffMillis();
            this._backoffMultiplier = castArg.getBackoffMultiplier();
            this._backoffJitter = castArg.getBackoffJitter();
            this._keepaliveDelay = castArg.getKeepaliveDelay();
            this._concurrentRpcLimit = castArg.getConcurrentRpcLimit();
            this._actorResponseWaitTime = castArg.getActorResponseWaitTime();
            this._odlHelloMessageCapabilities = castArg.getOdlHelloMessageCapabilities();
            isValidArg = true;
        }
        if (arg instanceof ConnectionOper) {
            castArg = (ConnectionOper)arg;
            this._sessionId = castArg.getSessionId();
            this._connectionStatus = castArg.getConnectionStatus();
            this._clusteredConnectionStatus = castArg.getClusteredConnectionStatus();
            this._connectedMessage = castArg.getConnectedMessage();
            this._availableCapabilities = castArg.getAvailableCapabilities();
            this._unavailableCapabilities = castArg.getUnavailableCapabilities();
            this._passThrough = castArg.getPassThrough();
            isValidArg = true;
        }
        if (arg instanceof DatastoreAccess) {
            castArg = (DatastoreAccess)arg;
            this._lockDatastore = castArg.getLockDatastore();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.Credentials, NetconfSchemaStorage, ConnectionParameters, ConnectionOper, DatastoreAccess]");
    }

    public Uint16 getActorResponseWaitTime() {
        return this._actorResponseWaitTime;
    }

    public AvailableCapabilities getAvailableCapabilities() {
        return this._availableCapabilities;
    }

    public Decimal64 getBackoffJitter() {
        return this._backoffJitter;
    }

    public Decimal64 getBackoffMultiplier() {
        return this._backoffMultiplier;
    }

    public ClusteredConnectionStatus getClusteredConnectionStatus() {
        return this._clusteredConnectionStatus;
    }

    public Uint16 getConcurrentRpcLimit() {
        return this._concurrentRpcLimit;
    }

    public String getConnectedMessage() {
        return this._connectedMessage;
    }

    public ConnectionOper.ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public Uint32 getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials getCredentials() {
        return this._credentials;
    }

    public Uint32 getDefaultRequestTimeoutMillis() {
        return this._defaultRequestTimeoutMillis;
    }

    public Host getHost() {
        return this._host;
    }

    public Uint32 getKeepaliveDelay() {
        return this._keepaliveDelay;
    }

    public Boolean getLockDatastore() {
        return this._lockDatastore;
    }

    public Uint32 getMaxBackoffMillis() {
        return this._maxBackoffMillis;
    }

    public Uint32 getMaxConnectionAttempts() {
        return this._maxConnectionAttempts;
    }

    public Uint16 getMinBackoffMillis() {
        return this._minBackoffMillis;
    }

    public NonModuleCapabilities getNonModuleCapabilities() {
        return this._nonModuleCapabilities;
    }

    public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
        return this._odlHelloMessageCapabilities;
    }

    public PassThrough getPassThrough() {
        return this._passThrough;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public Boolean getReconnectOnChangedSchema() {
        return this._reconnectOnChangedSchema;
    }

    public String getSchemaCacheDirectory() {
        return this._schemaCacheDirectory;
    }

    public Boolean getSchemaless() {
        return this._schemaless;
    }

    public SessionIdType getSessionId() {
        return this._sessionId;
    }

    public Boolean getTcpOnly() {
        return this._tcpOnly;
    }

    public UnavailableCapabilities getUnavailableCapabilities() {
        return this._unavailableCapabilities;
    }

    public YangLibrary getYangLibrary() {
        return this._yangLibrary;
    }

    public YangModuleCapabilities getYangModuleCapabilities() {
        return this._yangModuleCapabilities;
    }

    public <E$$ extends Augmentation<NetconfNode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkActorResponseWaitTimeRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public NetconfNodeBuilder setActorResponseWaitTime(Uint16 value) {
        if (value != null) {
            NetconfNodeBuilder.checkActorResponseWaitTimeRange(value.intValue());
        }
        this._actorResponseWaitTime = value;
        return this;
    }

    public NetconfNodeBuilder setAvailableCapabilities(AvailableCapabilities value) {
        this._availableCapabilities = value;
        return this;
    }

    private static void checkBackoffJitterRange(Decimal64 value) {
        for (Range<Decimal64> r : CHECKBACKOFFJITTERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKBACKOFFJITTERRANGE_RANGES, (Object)value);
    }

    public NetconfNodeBuilder setBackoffJitter(Decimal64 value) {
        if (value != null) {
            NetconfNodeBuilder.checkBackoffJitterRange(value);
        }
        this._backoffJitter = value;
        return this;
    }

    private static void checkBackoffMultiplierRange(Decimal64 value) {
        for (Range<Decimal64> r : CHECKBACKOFFMULTIPLIERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKBACKOFFMULTIPLIERRANGE_RANGES, (Object)value);
    }

    public NetconfNodeBuilder setBackoffMultiplier(Decimal64 value) {
        if (value != null) {
            NetconfNodeBuilder.checkBackoffMultiplierRange(value);
        }
        this._backoffMultiplier = value;
        return this;
    }

    public NetconfNodeBuilder setClusteredConnectionStatus(ClusteredConnectionStatus value) {
        this._clusteredConnectionStatus = value;
        return this;
    }

    public NetconfNodeBuilder setConcurrentRpcLimit(Uint16 value) {
        this._concurrentRpcLimit = value;
        return this;
    }

    public NetconfNodeBuilder setConnectedMessage(String value) {
        this._connectedMessage = value;
        return this;
    }

    public NetconfNodeBuilder setConnectionStatus(ConnectionOper.ConnectionStatus value) {
        this._connectionStatus = value;
        return this;
    }

    public NetconfNodeBuilder setConnectionTimeoutMillis(Uint32 value) {
        this._connectionTimeoutMillis = value;
        return this;
    }

    public NetconfNodeBuilder setCredentials(org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials value) {
        this._credentials = value;
        return this;
    }

    public NetconfNodeBuilder setDefaultRequestTimeoutMillis(Uint32 value) {
        this._defaultRequestTimeoutMillis = value;
        return this;
    }

    public NetconfNodeBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public NetconfNodeBuilder setKeepaliveDelay(Uint32 value) {
        this._keepaliveDelay = value;
        return this;
    }

    public NetconfNodeBuilder setLockDatastore(Boolean value) {
        this._lockDatastore = value;
        return this;
    }

    public NetconfNodeBuilder setMaxBackoffMillis(Uint32 value) {
        this._maxBackoffMillis = value;
        return this;
    }

    public NetconfNodeBuilder setMaxConnectionAttempts(Uint32 value) {
        this._maxConnectionAttempts = value;
        return this;
    }

    public NetconfNodeBuilder setMinBackoffMillis(Uint16 value) {
        this._minBackoffMillis = value;
        return this;
    }

    public NetconfNodeBuilder setNonModuleCapabilities(NonModuleCapabilities value) {
        this._nonModuleCapabilities = value;
        return this;
    }

    public NetconfNodeBuilder setOdlHelloMessageCapabilities(OdlHelloMessageCapabilities value) {
        this._odlHelloMessageCapabilities = value;
        return this;
    }

    public NetconfNodeBuilder setPassThrough(PassThrough value) {
        this._passThrough = value;
        return this;
    }

    public NetconfNodeBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public NetconfNodeBuilder setProtocol(Protocol value) {
        this._protocol = value;
        return this;
    }

    public NetconfNodeBuilder setReconnectOnChangedSchema(Boolean value) {
        this._reconnectOnChangedSchema = value;
        return this;
    }

    public NetconfNodeBuilder setSchemaCacheDirectory(String value) {
        this._schemaCacheDirectory = value;
        return this;
    }

    public NetconfNodeBuilder setSchemaless(Boolean value) {
        this._schemaless = value;
        return this;
    }

    public NetconfNodeBuilder setSessionId(SessionIdType value) {
        this._sessionId = value;
        return this;
    }

    public NetconfNodeBuilder setTcpOnly(Boolean value) {
        this._tcpOnly = value;
        return this;
    }

    public NetconfNodeBuilder setUnavailableCapabilities(UnavailableCapabilities value) {
        this._unavailableCapabilities = value;
        return this;
    }

    public NetconfNodeBuilder setYangLibrary(YangLibrary value) {
        this._yangLibrary = value;
        return this;
    }

    public NetconfNodeBuilder setYangModuleCapabilities(YangModuleCapabilities value) {
        this._yangModuleCapabilities = value;
        return this;
    }

    public NetconfNodeBuilder addAugmentation(Augmentation<NetconfNode> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfNode>>, Augmentation<NetconfNode>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NetconfNodeBuilder removeAugmentation(Class<? extends Augmentation<NetconfNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull NetconfNode build() {
        return new NetconfNodeImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)Decimal64.of((int)1, (long)0L), (Comparable)Decimal64.of((int)1, (long)5L));
        CHECKBACKOFFJITTERRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)Decimal64.of((int)1, (long)10L), (Comparable)Decimal64.of((int)1, (long)Long.MAX_VALUE));
        CHECKBACKOFFMULTIPLIERRANGE_RANGES = a;
    }

    private static final class NetconfNodeImpl
    extends AbstractAugmentable<NetconfNode>
    implements NetconfNode {
        private final Uint16 _actorResponseWaitTime;
        private final AvailableCapabilities _availableCapabilities;
        private final Decimal64 _backoffJitter;
        private final Decimal64 _backoffMultiplier;
        private final ClusteredConnectionStatus _clusteredConnectionStatus;
        private final Uint16 _concurrentRpcLimit;
        private final String _connectedMessage;
        private final ConnectionOper.ConnectionStatus _connectionStatus;
        private final Uint32 _connectionTimeoutMillis;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials _credentials;
        private final Uint32 _defaultRequestTimeoutMillis;
        private final Host _host;
        private final Uint32 _keepaliveDelay;
        private final Boolean _lockDatastore;
        private final Uint32 _maxBackoffMillis;
        private final Uint32 _maxConnectionAttempts;
        private final Uint16 _minBackoffMillis;
        private final NonModuleCapabilities _nonModuleCapabilities;
        private final OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
        private final PassThrough _passThrough;
        private final PortNumber _port;
        private final Protocol _protocol;
        private final Boolean _reconnectOnChangedSchema;
        private final String _schemaCacheDirectory;
        private final Boolean _schemaless;
        private final SessionIdType _sessionId;
        private final Boolean _tcpOnly;
        private final UnavailableCapabilities _unavailableCapabilities;
        private final YangLibrary _yangLibrary;
        private final YangModuleCapabilities _yangModuleCapabilities;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfNodeImpl(NetconfNodeBuilder base) {
            super(base.augmentation);
            this._actorResponseWaitTime = base.getActorResponseWaitTime();
            this._availableCapabilities = base.getAvailableCapabilities();
            this._backoffJitter = base.getBackoffJitter();
            this._backoffMultiplier = base.getBackoffMultiplier();
            this._clusteredConnectionStatus = base.getClusteredConnectionStatus();
            this._concurrentRpcLimit = base.getConcurrentRpcLimit();
            this._connectedMessage = base.getConnectedMessage();
            this._connectionStatus = base.getConnectionStatus();
            this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
            this._credentials = base.getCredentials();
            this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
            this._host = base.getHost();
            this._keepaliveDelay = base.getKeepaliveDelay();
            this._lockDatastore = base.getLockDatastore();
            this._maxBackoffMillis = base.getMaxBackoffMillis();
            this._maxConnectionAttempts = base.getMaxConnectionAttempts();
            this._minBackoffMillis = base.getMinBackoffMillis();
            this._nonModuleCapabilities = base.getNonModuleCapabilities();
            this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
            this._passThrough = base.getPassThrough();
            this._port = base.getPort();
            this._protocol = base.getProtocol();
            this._reconnectOnChangedSchema = base.getReconnectOnChangedSchema();
            this._schemaCacheDirectory = base.getSchemaCacheDirectory();
            this._schemaless = base.getSchemaless();
            this._sessionId = base.getSessionId();
            this._tcpOnly = base.getTcpOnly();
            this._unavailableCapabilities = base.getUnavailableCapabilities();
            this._yangLibrary = base.getYangLibrary();
            this._yangModuleCapabilities = base.getYangModuleCapabilities();
        }

        public Uint16 getActorResponseWaitTime() {
            return this._actorResponseWaitTime;
        }

        public AvailableCapabilities getAvailableCapabilities() {
            return this._availableCapabilities;
        }

        public Decimal64 getBackoffJitter() {
            return this._backoffJitter;
        }

        public Decimal64 getBackoffMultiplier() {
            return this._backoffMultiplier;
        }

        public ClusteredConnectionStatus getClusteredConnectionStatus() {
            return this._clusteredConnectionStatus;
        }

        public Uint16 getConcurrentRpcLimit() {
            return this._concurrentRpcLimit;
        }

        public String getConnectedMessage() {
            return this._connectedMessage;
        }

        public ConnectionOper.ConnectionStatus getConnectionStatus() {
            return this._connectionStatus;
        }

        public Uint32 getConnectionTimeoutMillis() {
            return this._connectionTimeoutMillis;
        }

        public org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials getCredentials() {
            return this._credentials;
        }

        public Uint32 getDefaultRequestTimeoutMillis() {
            return this._defaultRequestTimeoutMillis;
        }

        public Host getHost() {
            return this._host;
        }

        public Uint32 getKeepaliveDelay() {
            return this._keepaliveDelay;
        }

        public Boolean getLockDatastore() {
            return this._lockDatastore;
        }

        public Uint32 getMaxBackoffMillis() {
            return this._maxBackoffMillis;
        }

        public Uint32 getMaxConnectionAttempts() {
            return this._maxConnectionAttempts;
        }

        public Uint16 getMinBackoffMillis() {
            return this._minBackoffMillis;
        }

        public NonModuleCapabilities getNonModuleCapabilities() {
            return this._nonModuleCapabilities;
        }

        public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
            return this._odlHelloMessageCapabilities;
        }

        public PassThrough getPassThrough() {
            return this._passThrough;
        }

        public PortNumber getPort() {
            return this._port;
        }

        public Protocol getProtocol() {
            return this._protocol;
        }

        public Boolean getReconnectOnChangedSchema() {
            return this._reconnectOnChangedSchema;
        }

        public String getSchemaCacheDirectory() {
            return this._schemaCacheDirectory;
        }

        public Boolean getSchemaless() {
            return this._schemaless;
        }

        public SessionIdType getSessionId() {
            return this._sessionId;
        }

        public Boolean getTcpOnly() {
            return this._tcpOnly;
        }

        public UnavailableCapabilities getUnavailableCapabilities() {
            return this._unavailableCapabilities;
        }

        public YangLibrary getYangLibrary() {
            return this._yangLibrary;
        }

        public YangModuleCapabilities getYangModuleCapabilities() {
            return this._yangModuleCapabilities;
        }

        public AvailableCapabilities nonnullAvailableCapabilities() {
            return Objects.requireNonNullElse(this.getAvailableCapabilities(), AvailableCapabilitiesBuilder.empty());
        }

        public ClusteredConnectionStatus nonnullClusteredConnectionStatus() {
            return Objects.requireNonNullElse(this.getClusteredConnectionStatus(), ClusteredConnectionStatusBuilder.empty());
        }

        public NonModuleCapabilities nonnullNonModuleCapabilities() {
            return Objects.requireNonNullElse(this.getNonModuleCapabilities(), NonModuleCapabilitiesBuilder.empty());
        }

        public OdlHelloMessageCapabilities nonnullOdlHelloMessageCapabilities() {
            return Objects.requireNonNullElse(this.getOdlHelloMessageCapabilities(), OdlHelloMessageCapabilitiesBuilder.empty());
        }

        public PassThrough nonnullPassThrough() {
            return Objects.requireNonNullElse(this.getPassThrough(), PassThroughBuilder.empty());
        }

        public Protocol nonnullProtocol() {
            return Objects.requireNonNullElse(this.getProtocol(), ProtocolBuilder.empty());
        }

        public UnavailableCapabilities nonnullUnavailableCapabilities() {
            return Objects.requireNonNullElse(this.getUnavailableCapabilities(), UnavailableCapabilitiesBuilder.empty());
        }

        public YangLibrary nonnullYangLibrary() {
            return Objects.requireNonNullElse(this.getYangLibrary(), YangLibraryBuilder.empty());
        }

        public YangModuleCapabilities nonnullYangModuleCapabilities() {
            return Objects.requireNonNullElse(this.getYangModuleCapabilities(), YangModuleCapabilitiesBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NetconfNode.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NetconfNode.bindingEquals(this, obj);
        }

        public String toString() {
            return NetconfNode.bindingToString(this);
        }
    }
}

