/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.util.concurrent.ForwardingBlockingQueue;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@NonNullByDefault
@Component(service={NetconfTopologySchemaAssembler.class}, configurationPid={"org.opendaylight.netconf.topology"})
@Designate(ocd=Configuration.class)
public final class NetconfTopologySchemaAssembler
implements AutoCloseable {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("topology-schema-assembler-%d").setDaemon(true).build();
    private final ThreadPoolExecutor executor;

    public NetconfTopologySchemaAssembler(int maxThreads) {
        this.executor = new ThreadPoolExecutor(0, maxThreads, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)((Object)new SynchronousBlockingQueue()), THREAD_FACTORY, (runnable, exec) -> {
            try {
                exec.getQueue().put(runnable);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Interrupted while waiting on the queue", e);
            }
        });
    }

    @Activate
    public NetconfTopologySchemaAssembler(Configuration config) {
        this(config.assembler$_$max$_$threads());
    }

    @Override
    @Deactivate
    public void close() {
        this.executor.shutdown();
    }

    Executor executor() {
        return this.executor;
    }

    private static final class SynchronousBlockingQueue
    extends ForwardingBlockingQueue<Runnable> {
        private final LinkedBlockingQueue<Runnable> delegate = new LinkedBlockingQueue();

        private SynchronousBlockingQueue() {
        }

        protected BlockingQueue<Runnable> delegate() {
            return this.delegate;
        }

        public boolean offer(Runnable o) {
            return false;
        }
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(min="1", description="Maximum number of concurrent schema assmbly threads. This effectively limits the memory footprint by not\nallowing too many YANG parser executions to run at the same time.")
        public int assembler$_$max$_$threads() default 4;
    }
}

