/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.KeyAuth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.KeyAuthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPwBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPwUnencryptedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.key.auth.KeyBasedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.login.pw.LoginPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.login.pw.unencrypted.LoginPasswordUnencryptedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.NetconfNodeAugmentedOptionalBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.CreateDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.CreateDeviceOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.CreateDeviceOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.DeleteDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.DeleteDeviceOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.DeleteDeviceOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.NetconfNodeAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.NetconfNodeAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.LoginPwUnencrypted;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.key.auth.KeyBased;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.login.pw.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.login.pw.unencrypted.LoginPasswordUnencrypted;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class NetconfTopologyRPCProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyRPCProvider.class);
    private final @NonNull InstanceIdentifier<Topology> topologyPath;
    private final @NonNull AAAEncryptionService encryptionService;
    private final @NonNull DataBroker dataBroker;
    private final Registration reg;

    public NetconfTopologyRPCProvider(RpcProviderService rpcProviderService, DataBroker dataBroker, AAAEncryptionService encryptionService, String topologyId) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.encryptionService = Objects.requireNonNull(encryptionService);
        this.topologyPath = InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Key)new TopologyKey(new TopologyId(topologyId))).build();
        this.reg = rpcProviderService.registerRpcImplementations(new Rpc[]{this::createDevice, this::deleteDevice});
    }

    protected @NonNull InstanceIdentifier<Topology> topologyPath() {
        return this.topologyPath;
    }

    @Override
    public void close() {
        this.reg.close();
    }

    private ListenableFuture<RpcResult<CreateDeviceOutput>> createDevice(CreateDeviceInput input) {
        NetconfNodeAugment netconfNode = this.encryptPassword(input);
        NodeId nodeId = new NodeId(input.getNodeId());
        NodeBuilder nodeBuilder = new NodeBuilder().setNodeId(nodeId).addAugmentation((Augmentation)netconfNode);
        if (input.getIgnoreMissingSchemaSources() != null) {
            NetconfNodeAugmentedOptionalBuilder netconfNodeOptionalBuilder = new NetconfNodeAugmentedOptionalBuilder(input);
            nodeBuilder.addAugmentation((Augmentation)netconfNodeOptionalBuilder.build());
        }
        SettableFuture futureResult = SettableFuture.create();
        this.writeToConfigDS(nodeBuilder.build(), nodeId, (SettableFuture<RpcResult<CreateDeviceOutput>>)futureResult);
        return futureResult;
    }

    private ListenableFuture<RpcResult<DeleteDeviceOutput>> deleteDevice(DeleteDeviceInput input) {
        NodeId nodeId = new NodeId(input.getNodeId());
        KeyedInstanceIdentifier niid = this.topologyPath.child(Node.class, (Key)new NodeKey(nodeId));
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        wtx.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)niid);
        final SettableFuture rpcFuture = SettableFuture.create();
        wtx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("delete-device RPC: Removed netconf node successfully.");
                rpcFuture.set((Object)RpcResultBuilder.success((Object)new DeleteDeviceOutputBuilder().build()).build());
            }

            public void onFailure(Throwable exception) {
                LOG.error("delete-device RPC: Unable to remove netconf node.", exception);
                rpcFuture.setException(exception);
            }
        }, MoreExecutors.directExecutor());
        return rpcFuture;
    }

    @VisibleForTesting
    NetconfNodeAugment encryptPassword(CreateDeviceInput input) {
        NetconfNodeBuilder builder = new NetconfNodeBuilder();
        builder.fieldsFrom(input);
        builder.setCredentials(this.translate(input.getRpcCredentials()));
        return new NetconfNodeAugmentBuilder().setNetconfNode(builder.build()).build();
    }

    private Credentials translate(RpcCredentials credentialsRpc) {
        RpcCredentials rpcCredentials = credentialsRpc;
        Objects.requireNonNull(rpcCredentials);
        RpcCredentials rpcCredentials2 = rpcCredentials;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.KeyAuth.class, LoginPw.class, LoginPwUnencrypted.class}, (Object)rpcCredentials2, n)) {
            case 0 -> {
                KeyAuth var4_7;
                org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.KeyAuth keyAuth = (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.rpc.credentials.KeyAuth)rpcCredentials2;
                KeyBased loginPassword = keyAuth.getKeyBased();
                yield var4_7 = new KeyAuthBuilder().setKeyBased(new KeyBasedBuilder().setUsername(loginPassword.getUsername()).setKeyId(loginPassword.getKeyId()).build()).build();
            }
            case 1 -> {
                byte[] cipherBytes;
                LoginPw loginPw = (LoginPw)rpcCredentials2;
                LoginPassword loginPassword = loginPw.getLoginPassword();
                try {
                    cipherBytes = this.encryptionService.encrypt(loginPassword.getPassword().getBytes(StandardCharsets.UTF_8));
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException("Failed to encrypt password", e);
                }
                org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPw var4_8 = new LoginPwBuilder().setLoginPassword(new LoginPasswordBuilder().setUsername(loginPassword.getUsername()).setPassword(cipherBytes).build()).build();
                yield var4_8;
            }
            case 2 -> {
                LoginPwUnencrypted loginPwUnencrypted = (LoginPwUnencrypted)rpcCredentials2;
                LoginPasswordUnencrypted loginPassword = loginPwUnencrypted.getLoginPasswordUnencrypted();
                org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPwUnencrypted var4_9 = new LoginPwUnencryptedBuilder().setLoginPasswordUnencrypted(new LoginPasswordUnencryptedBuilder().setUsername(loginPassword.getUsername()).setPassword(loginPassword.getPassword()).build()).build();
                yield var4_9;
            }
            default -> throw new IllegalArgumentException("Unsupported credential type: " + String.valueOf(credentialsRpc.getClass()));
        };
    }

    private void writeToConfigDS(Node node, NodeId nodeId, final SettableFuture<RpcResult<CreateDeviceOutput>> futureResult) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        KeyedInstanceIdentifier niid = this.topologyPath.child(Node.class, (Key)new NodeKey(nodeId));
        writeTransaction.mergeParentStructureMerge(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)niid, (DataObject)node);
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("add-netconf-node RPC: Added netconf node successfully.");
                futureResult.set((Object)RpcResultBuilder.success((Object)new CreateDeviceOutputBuilder().build()).build());
            }

            public void onFailure(Throwable exception) {
                LOG.error("add-netconf-node RPC: Unable to add netconf node.", exception);
                futureResult.setException(exception);
            }
        }, MoreExecutors.directExecutor());
    }
}

