/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCapabilities;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.spi.NetconfDeviceSalFacade;
import org.opendaylight.netconf.topology.spi.NetconfDeviceTopologyAdapter;
import org.opendaylight.netconf.topology.spi.NetconfNodeUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfTopologyDeviceSalFacade
extends NetconfDeviceSalFacade {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyDeviceSalFacade.class);
    private final NetconfDeviceTopologyAdapter datastoreAdapter;

    public NetconfTopologyDeviceSalFacade(RemoteDeviceId id, Credentials credentials, DOMMountPointService mountPointService, boolean lockDatastore, DataBroker dataBroker) {
        super(id, mountPointService, NetconfNodeUtils.defaultTopologyMountPath(id), lockDatastore);
        this.datastoreAdapter = new NetconfDeviceTopologyAdapter(dataBroker, NetconfNodeUtils.DEFAULT_TOPOLOGY_IID, id, credentials);
    }

    public synchronized void onDeviceConnected(NetconfDeviceSchema deviceSchema, NetconfSessionPreferences sessionPreferences, RemoteDeviceServices services) {
        if (this.closed()) {
            LOG.warn("{}: Device adapter was closed before device connected setup finished.", (Object)this.id);
            return;
        }
        super.onDeviceConnected(deviceSchema, sessionPreferences, services);
        this.datastoreAdapter.updateDeviceData(true, deviceSchema.capabilities(), sessionPreferences.sessionId());
    }

    public synchronized void onDeviceDisconnected() {
        if (this.closed()) {
            LOG.warn("{}: Device adapter was closed before device disconnected setup finished.", (Object)this.id);
            return;
        }
        this.datastoreAdapter.updateDeviceData(false, NetconfDeviceCapabilities.empty(), null);
        super.onDeviceDisconnected();
    }

    public synchronized void onDeviceFailed(Throwable throwable) {
        if (this.closed()) {
            LOG.warn("{}: Device adapter was closed before device failure setup finished.", (Object)this.id, (Object)throwable);
            return;
        }
        this.datastoreAdapter.setDeviceAsFailed(throwable);
        super.onDeviceFailed(throwable);
    }

    public synchronized void close() {
        ListenableFuture<Empty> future = this.datastoreAdapter.shutdown();
        super.close();
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for datastore adapter shutdown", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Datastore adapter shutdown failed", e);
        }
    }
}

