/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.client.mdsal.UserPreferences;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.NonModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.YangModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class NetconfNodeUtils {
    @Deprecated(forRemoval=true)
    public static final String DEFAULT_TOPOLOGY_NAME = TopologyNetconf.QNAME.getLocalName();
    @Deprecated(forRemoval=true)
    public static final KeyedInstanceIdentifier<Topology, TopologyKey> DEFAULT_TOPOLOGY_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Key)new TopologyKey(new TopologyId(DEFAULT_TOPOLOGY_NAME)));
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id").intern();
    private static final YangInstanceIdentifier DEFAULT_TOPOLOGY_NODE = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((QName)Topology.QNAME, (String)"topology-id"), (Object)DEFAULT_TOPOLOGY_NAME).node(Node.QNAME).build();

    private NetconfNodeUtils() {
    }

    public static @NonNull InetSocketAddress toInetSocketAddress(NetconfNode node) {
        Host host = node.requireHost();
        int port = node.requirePort().getValue().toJava();
        IpAddress ipAddress = host.getIpAddress();
        return ipAddress != null ? new InetSocketAddress(IetfInetUtil.inetAddressFor((IpAddress)ipAddress), port) : new InetSocketAddress(host.getDomainName().getValue(), port);
    }

    public static @NonNull RemoteDeviceId toRemoteDeviceId(NodeId nodeId, NetconfNode node) {
        return new RemoteDeviceId(nodeId.getValue(), NetconfNodeUtils.toInetSocketAddress(node));
    }

    public static @Nullable UserPreferences extractUserCapabilities(NetconfNode node) {
        boolean overrideNonModuleCaps;
        boolean overrideYangModuleCaps;
        YangModuleCapabilities moduleCaps = node.getYangModuleCapabilities();
        NonModuleCapabilities nonModuleCaps = node.getNonModuleCapabilities();
        if (moduleCaps == null && nonModuleCaps == null) {
            return null;
        }
        ArrayList capabilities = new ArrayList();
        if (moduleCaps != null) {
            capabilities.addAll(moduleCaps.getCapability());
            overrideYangModuleCaps = moduleCaps.getOverride();
        } else {
            overrideYangModuleCaps = false;
        }
        NetconfSessionPreferences sessionPreferences = NetconfSessionPreferences.fromStrings(capabilities, (AvailableCapability.CapabilityOrigin)AvailableCapability.CapabilityOrigin.DeviceAdvertised, (SessionIdType)node.getSessionId());
        ImmutableMap nonModulePrefs = sessionPreferences.nonModuleCaps();
        if (!nonModulePrefs.isEmpty()) {
            throw new IllegalArgumentException("List yang-module-capabilities/capability should contain only module based capabilities. Non-module capabilities used: " + String.valueOf(nonModulePrefs));
        }
        if (nonModuleCaps != null) {
            capabilities.addAll(nonModuleCaps.getCapability());
            overrideNonModuleCaps = nonModuleCaps.getOverride();
        } else {
            overrideNonModuleCaps = false;
        }
        return new UserPreferences(NetconfSessionPreferences.fromStrings(capabilities, (AvailableCapability.CapabilityOrigin)AvailableCapability.CapabilityOrigin.UserDefined, (SessionIdType)node.getSessionId()), overrideYangModuleCaps, overrideNonModuleCaps);
    }

    @Deprecated(forRemoval=true)
    public static @NonNull YangInstanceIdentifier defaultTopologyMountPath(RemoteDeviceId id) {
        return DEFAULT_TOPOLOGY_NODE.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Node.QNAME, (QName)NODE_ID_QNAME, (Object)id.name()));
    }
}

