/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.mdsal.LibraryModulesSchemas;
import org.opendaylight.netconf.client.mdsal.LibrarySchemaSourceProvider;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceBuilder;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.SchemalessNetconfDevice;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDevice;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.spi.KeepaliveSalFacade;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.topology.spi.ConnectGivenUpException;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfNodeUtils;
import org.opendaylight.netconf.topology.spi.NetconfTopologySchemaAssembler;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.netconf.schema.storage.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.NetconfNodeAugmentedOptional;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfNodeHandler
extends AbstractRegistration
implements RemoteDeviceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNodeHandler.class);
    private final @NonNull List<Registration> yanglibRegistrations;
    private final @NonNull NetconfClientFactory clientFactory;
    private final @NonNull NetconfDeviceCommunicator communicator;
    private final @NonNull RemoteDeviceHandler delegate;
    private final @NonNull NetconfTimer timer;
    private final @NonNull RemoteDeviceId deviceId;
    private final @NonNull NetconfNode node;
    private final @NonNull NodeId nodeId;
    private final @NonNull NetconfClientConfigurationBuilderFactory builderFactory;
    private final long maxBackoff;
    private final long maxAttempts;
    private final int minBackoff;
    private final double backoffMultiplier;
    private final double jitter;
    private @GuardedBy(value={"this"}) NetconfClientConfiguration clientConfig;
    private @GuardedBy(value={"this"}) long attempts;
    private @GuardedBy(value={"this"}) long lastMultipliedBackoff;
    private @GuardedBy(value={"this"}) Task currentTask;

    public NetconfNodeHandler(NetconfClientFactory clientFactory, NetconfTimer timer, BaseNetconfSchemaProvider baseSchemaProvider, SchemaResourceManager schemaManager, NetconfTopologySchemaAssembler schemaAssembler, NetconfClientConfigurationBuilderFactory builderFactory, DeviceActionFactory deviceActionFactory, RemoteDeviceHandler delegate, RemoteDeviceId deviceId, NodeId nodeId, NetconfNode node, NetconfNodeAugmentedOptional nodeOptional) {
        SchemalessNetconfDevice device;
        NetconfNodeHandler salFacade;
        KeepaliveSalFacade keepAliveFacade;
        long keepaliveDelay;
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.timer = Objects.requireNonNull(timer);
        this.delegate = Objects.requireNonNull(delegate);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.node = Objects.requireNonNull(node);
        this.nodeId = Objects.requireNonNull(nodeId);
        this.builderFactory = Objects.requireNonNull(builderFactory);
        this.maxAttempts = node.requireMaxConnectionAttempts().toJava();
        this.minBackoff = node.requireMinBackoffMillis().toJava();
        this.backoffMultiplier = node.requireBackoffMultiplier().doubleValue();
        long potentialMaxBackoff = node.requireMaxBackoffMillis().toJava();
        this.maxBackoff = potentialMaxBackoff >= (long)this.minBackoff ? potentialMaxBackoff : (long)this.minBackoff;
        this.jitter = node.getBackoffJitter().doubleValue();
        if (nodeOptional != null && nodeOptional.getIgnoreMissingSchemaSources().getAllowed().booleanValue()) {
            LOG.warn("Ignoring missing schema sources is not currently implemented for {}", (Object)deviceId);
        }
        if ((keepaliveDelay = node.requireKeepaliveDelay().toJava()) > 0L) {
            LOG.info("Adding keepalive facade, for device {}", (Object)nodeId);
            keepAliveFacade = new KeepaliveSalFacade(deviceId, (RemoteDeviceHandler)this, timer, keepaliveDelay, node.requireDefaultRequestTimeoutMillis().toJava());
            salFacade = keepAliveFacade;
        } else {
            salFacade = this;
            keepAliveFacade = null;
        }
        if (node.requireSchemaless().booleanValue()) {
            device = new SchemalessNetconfDevice(baseSchemaProvider, deviceId, (RemoteDeviceHandler)salFacade);
            this.yanglibRegistrations = List.of();
        } else {
            DeviceNetconfSchemaProvider resources = schemaManager.getSchemaResources(node.getSchemaCacheDirectory(), (Object)nodeId.getValue());
            device = new NetconfDeviceBuilder().setReconnectOnSchemasChange(node.requireReconnectOnChangedSchema().booleanValue()).setBaseSchemaProvider(baseSchemaProvider).setDeviceSchemaProvider(resources).setProcessingExecutor(schemaAssembler.executor()).setId(deviceId).setSalFacade((RemoteDeviceHandler)salFacade).setDeviceActionFactory(deviceActionFactory).build();
            this.yanglibRegistrations = NetconfNodeHandler.registerDeviceSchemaSources(deviceId, node, resources);
        }
        int rpcMessageLimit = node.requireConcurrentRpcLimit().toJava();
        if (rpcMessageLimit < 1) {
            LOG.info("Concurrent rpc limit is smaller than 1, no limit will be enforced for device {}", (Object)deviceId);
        }
        this.communicator = new NetconfDeviceCommunicator(deviceId, (RemoteDevice)device, rpcMessageLimit, NetconfNodeUtils.extractUserCapabilities(node));
        if (keepAliveFacade != null) {
            keepAliveFacade.setListener(this.communicator);
        }
    }

    public synchronized void connect() {
        this.attempts = 1L;
        this.lastMultipliedBackoff = this.minBackoff;
        this.lockedConnect();
    }

    @Holding(value={"this"})
    private void lockedConnect() {
        ListenableFuture connectFuture;
        if (this.clientConfig == null) {
            try {
                this.clientConfig = this.builderFactory.createClientConfigurationBuilder(this.nodeId, this.node).withSessionListener((NetconfClientSessionListener)this.communicator).build();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                LOG.warn("RemoteDevice{{}} failed to connect", (Object)this.nodeId, (Object)e);
                this.delegate.onDeviceFailed((Throwable)e);
                return;
            }
        }
        try {
            connectFuture = this.clientFactory.createClient(this.clientConfig);
        }
        catch (UnsupportedConfigurationException e) {
            this.onDeviceFailed(e);
            return;
        }
        ConnectingTask nextTask = new ConnectingTask((ListenableFuture<NetconfClientSession>)connectFuture);
        this.currentTask = nextTask;
        Futures.addCallback((ListenableFuture)connectFuture, (FutureCallback)nextTask, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized void connectComplete(ConnectingTask task) {
        this.completeTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectFailed(ConnectingTask task, Throwable cause) {
        NetconfNodeHandler netconfNodeHandler = this;
        synchronized (netconfNodeHandler) {
            if (this.completeTask(task)) {
                return;
            }
            LOG.debug("Connection attempt {} to {} failed", new Object[]{this.attempts, this.deviceId, cause});
        }
        this.reconnectOrFail();
    }

    @Holding(value={"this"})
    private boolean completeTask(ConnectingTask task) {
        if (task.equals(this.currentTask)) {
            this.currentTask = null;
            return false;
        }
        LOG.warn("Ignoring connection completion, expected {} actual {}", (Object)this.currentTask, (Object)task);
        return true;
    }

    protected synchronized void removeRegistration() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        this.communicator.close();
        this.delegate.close();
        this.yanglibRegistrations.forEach(Registration::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeviceConnected(NetconfDeviceSchema deviceSchema, NetconfSessionPreferences sessionPreferences, RemoteDeviceServices services) {
        NetconfNodeHandler netconfNodeHandler = this;
        synchronized (netconfNodeHandler) {
            this.attempts = 0L;
        }
        this.delegate.onDeviceConnected(deviceSchema, sessionPreferences, services);
    }

    public void onDeviceDisconnected() {
        if (this.isClosed()) {
            return;
        }
        this.delegate.onDeviceDisconnected();
        this.reconnectOrFail();
    }

    public void onDeviceFailed(Throwable throwable) {
        LOG.debug("Connection attempt failed", throwable);
        this.reconnectOrFail();
    }

    public void onNotification(DOMNotification domNotification) {
        this.delegate.onNotification(domNotification);
    }

    private void reconnectOrFail() {
        Exception ex = this.scheduleReconnect();
        if (ex != null) {
            this.delegate.onDeviceFailed((Throwable)ex);
        }
    }

    private synchronized Exception scheduleReconnect() {
        if (this.isClosed()) {
            return null;
        }
        if (this.maxAttempts > 0L && this.attempts >= this.maxAttempts) {
            LOG.info("Failed to connect {} after {} attempts, not attempting", (Object)this.deviceId, (Object)this.attempts);
            return new ConnectGivenUpException("Given up connecting " + String.valueOf(this.deviceId) + " after " + this.attempts + " attempts");
        }
        this.lastMultipliedBackoff = this.attempts != 0L ? (long)Math.min((double)this.lastMultipliedBackoff * this.backoffMultiplier, (double)this.maxBackoff) : (long)this.minBackoff;
        long backoffMillis = (long)((double)this.lastMultipliedBackoff * (Math.random() * (this.jitter * 2.0) + (1.0 - this.jitter)));
        ++this.attempts;
        LOG.debug("Retrying {} connection attempt {} after {} milliseconds", new Object[]{this.deviceId, this.attempts, backoffMillis});
        this.currentTask = new SleepingTask(this.timer.newTimeout(this::reconnect, backoffMillis, TimeUnit.MILLISECONDS));
        return null;
    }

    private synchronized void reconnect(Timeout timeout) {
        this.currentTask = null;
        if (this.notClosed()) {
            this.lockedConnect();
        }
    }

    private static List<Registration> registerDeviceSchemaSources(RemoteDeviceId remoteDeviceId, NetconfNode node, DeviceNetconfSchemaProvider resources) {
        Uri uri;
        YangLibrary yangLibrary = node.getYangLibrary();
        if (yangLibrary != null && (uri = yangLibrary.getYangLibraryUrl()) != null) {
            ArrayList<Registration> registrations = new ArrayList<Registration>();
            String yangLibURL = uri.getValue();
            String yangLibUsername = yangLibrary.getUsername();
            String yangLigPassword = yangLibrary.getPassword();
            LibraryModulesSchemas schemas = yangLibUsername != null && yangLigPassword != null ? LibraryModulesSchemas.create((String)yangLibURL, (String)yangLibUsername, (String)yangLigPassword) : LibraryModulesSchemas.create((String)yangLibURL);
            SchemaSourceRegistry registry = resources.registry();
            for (Map.Entry entry : schemas.getAvailableModels().entrySet()) {
                registrations.add(registry.registerSchemaSource((SchemaSourceProvider)new LibrarySchemaSourceProvider(schemas.getAvailableModels()), PotentialSchemaSource.create((SourceIdentifier)((SourceIdentifier)entry.getKey()), YangTextSource.class, (int)PotentialSchemaSource.Costs.REMOTE_IO.getValue())));
            }
            return List.copyOf(registrations);
        }
        return List.of();
    }

    @VisibleForTesting
    synchronized long attempts() {
        return this.attempts;
    }

    private final class ConnectingTask
    extends Task
    implements FutureCallback<NetconfClientSession> {
        private final ListenableFuture<NetconfClientSession> future;

        ConnectingTask(ListenableFuture<NetconfClientSession> future) {
            this.future = Objects.requireNonNull(future);
        }

        @Override
        void cancel() {
            this.future.cancel(false);
        }

        public void onSuccess(NetconfClientSession result) {
            NetconfNodeHandler.this.connectComplete(this);
        }

        public void onFailure(Throwable cause) {
            if (cause instanceof CancellationException) {
                NetconfNodeHandler.this.connectComplete(this);
            } else {
                NetconfNodeHandler.this.connectFailed(this, cause);
            }
        }
    }

    private static abstract sealed class Task
    permits ConnectingTask, SleepingTask {
        private Task() {
        }

        abstract void cancel();
    }

    private static final class SleepingTask
    extends Task {
        private final Timeout timeout;

        SleepingTask(Timeout timeout) {
            this.timeout = Objects.requireNonNull(timeout);
        }

        @Override
        void cancel() {
            this.timeout.cancel();
        }
    }
}

