/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCapabilities;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.ConnectionOper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.AvailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.ClusteredConnectionStatusBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.UnavailableCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.unavailable.capabilities.UnavailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.unavailable.capabilities.UnavailableCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.NetconfNodeAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.NetconfNodeAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfDeviceTopologyAdapter
implements FutureCallback<Empty> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceTopologyAdapter.class);
    private final @NonNull KeyedInstanceIdentifier<Topology, TopologyKey> topologyPath;
    private final DataBroker dataBroker;
    private final RemoteDeviceId id;
    private final Credentials credentials;
    private @GuardedBy(value={"this"}) SettableFuture<Empty> closeFuture;
    private @GuardedBy(value={"this"}) TransactionChain txChain;

    public NetconfDeviceTopologyAdapter(DataBroker dataBroker, KeyedInstanceIdentifier<Topology, TopologyKey> topologyPath, RemoteDeviceId id, Credentials credentials) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.topologyPath = Objects.requireNonNull(topologyPath);
        this.id = Objects.requireNonNull(id);
        this.credentials = Objects.requireNonNull(credentials);
        this.txChain = dataBroker.createMergingTransactionChain();
        this.txChain.addCallback((FutureCallback)this);
        WriteTransaction tx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Init device state transaction {} putting if absent operational data started.", (Object)id, tx.getIdentifier());
        KeyedInstanceIdentifier<Node, NodeKey> nodePath = this.nodePath();
        tx.put(LogicalDatastoreType.OPERATIONAL, nodePath, (DataObject)new NodeBuilder().withKey((NodeKey)nodePath.getKey()).addAugmentation((Augmentation)new NetconfNodeAugmentBuilder().setNetconfNode(new NetconfNodeBuilder().setConnectionStatus(ConnectionOper.ConnectionStatus.Connecting).setHost(id.host()).setCredentials(credentials).setPort(new PortNumber(Uint16.valueOf((int)id.address().getPort()))).build()).build()).build());
        LOG.trace("{}: Init device state transaction {} putting operational data ended.", (Object)id, tx.getIdentifier());
        this.commitTransaction(tx, "init");
    }

    public synchronized void updateDeviceData(boolean up, NetconfDeviceCapabilities capabilities, SessionIdType sessionId) {
        WriteTransaction tx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Update device state transaction {} merging operational data started.", (Object)this.id, tx.getIdentifier());
        tx.put(LogicalDatastoreType.OPERATIONAL, this.netconfNodePath(), (DataObject)this.newNetconfNodeBuilder(up, capabilities, sessionId).build());
        LOG.trace("{}: Update device state transaction {} merging operational data ended.", (Object)this.id, tx.getIdentifier());
        this.commitTransaction(tx, "update");
    }

    public synchronized void updateClusteredDeviceData(boolean up, String masterAddress, NetconfDeviceCapabilities capabilities, SessionIdType sessionId) {
        WriteTransaction tx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Update device state transaction {} merging operational data started.", (Object)this.id, tx.getIdentifier());
        tx.put(LogicalDatastoreType.OPERATIONAL, this.netconfNodePath(), (DataObject)this.newNetconfNodeBuilder(up, capabilities, sessionId).setClusteredConnectionStatus(new ClusteredConnectionStatusBuilder().setNetconfMasterNode(masterAddress).build()).build());
        LOG.trace("{}: Update device state transaction {} merging operational data ended.", (Object)this.id, tx.getIdentifier());
        this.commitTransaction(tx, "update");
    }

    public synchronized void setDeviceAsFailed(Throwable throwable) {
        NetconfNode data = new NetconfNodeBuilder().setHost(this.id.host()).setPort(new PortNumber(Uint16.valueOf((int)this.id.address().getPort()))).setCredentials(this.credentials).setConnectionStatus(ConnectionOper.ConnectionStatus.UnableToConnect).setConnectedMessage(NetconfDeviceTopologyAdapter.extractReason(throwable)).build();
        WriteTransaction tx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Setting device state as failed {} putting operational data started.", (Object)this.id, tx.getIdentifier());
        tx.put(LogicalDatastoreType.OPERATIONAL, this.netconfNodePath(), (DataObject)data);
        LOG.trace("{}: Setting device state as failed {} putting operational data ended.", (Object)this.id, tx.getIdentifier());
        this.commitTransaction(tx, "update-failed-device");
    }

    public synchronized ListenableFuture<Empty> shutdown() {
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.closeFuture = SettableFuture.create();
        WriteTransaction tx = this.txChain.newWriteOnlyTransaction();
        LOG.trace("{}: Close device state transaction {} removing all data started.", (Object)this.id, tx.getIdentifier());
        tx.delete(LogicalDatastoreType.OPERATIONAL, this.nodePath());
        LOG.trace("{}: Close device state transaction {} removing all data ended.", (Object)this.id, tx.getIdentifier());
        this.commitTransaction(tx, "close");
        this.txChain.close();
        return this.closeFuture;
    }

    private @NonNull KeyedInstanceIdentifier<Node, NodeKey> nodePath() {
        return this.topologyPath.child(Node.class, (Key)new NodeKey(new NodeId(this.id.name())));
    }

    private @NonNull InstanceIdentifier<NetconfNode> netconfNodePath() {
        return this.nodePath().augmentation(NetconfNodeAugment.class).child(NetconfNode.class);
    }

    private NetconfNodeBuilder newNetconfNodeBuilder(boolean up, NetconfDeviceCapabilities capabilities, SessionIdType sessionId) {
        return new NetconfNodeBuilder().setHost(this.id.host()).setPort(new PortNumber(Uint16.valueOf((int)this.id.address().getPort()))).setCredentials(this.credentials).setConnectionStatus(up ? ConnectionOper.ConnectionStatus.Connected : ConnectionOper.ConnectionStatus.Connecting).setAvailableCapabilities(new AvailableCapabilitiesBuilder().setAvailableCapability((List)ImmutableList.builder().addAll((Iterable)capabilities.nonModuleBasedCapabilities()).addAll((Iterable)capabilities.resolvedCapabilities()).build()).build()).setUnavailableCapabilities(new UnavailableCapabilitiesBuilder().setUnavailableCapability(capabilities.unresolvedCapabilites().entrySet().stream().map(unresolved -> new UnavailableCapabilityBuilder().setCapability(((QName)unresolved.getKey()).toString()).setFailureReason((UnavailableCapability.FailureReason)unresolved.getValue()).build()).toList()).build()).setSessionId(sessionId);
    }

    private void commitTransaction(final WriteTransaction transaction, final String txType) {
        LOG.trace("{}: Committing Transaction {}:{}", new Object[]{this.id, txType, transaction.getIdentifier()});
        transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.trace("{}: Transaction({}) {} SUCCESSFUL", new Object[]{NetconfDeviceTopologyAdapter.this.id, txType, transaction.getIdentifier()});
            }

            public void onFailure(Throwable throwable) {
                LOG.error("{}: Transaction({}) {} FAILED!", new Object[]{NetconfDeviceTopologyAdapter.this.id, txType, transaction.getIdentifier(), throwable});
            }
        }, MoreExecutors.directExecutor());
    }

    public synchronized void onFailure(Throwable cause) {
        LOG.warn("{}: transaction chain FAILED!", (Object)this.id, (Object)cause);
        if (this.closeFuture != null) {
            this.closeFuture.setException(cause);
            return;
        }
        this.txChain.close();
        this.txChain = this.dataBroker.createMergingTransactionChain();
        LOG.info("{}: TransactionChain reset to {}", (Object)this.id, (Object)this.txChain);
        this.txChain.addCallback((FutureCallback)this);
    }

    public synchronized void onSuccess(Empty result) {
        LOG.trace("{}: transaction chain SUCCESSFUL", (Object)this.id);
        this.closeFuture.set((Object)Empty.value());
    }

    private static @NonNull String extractReason(Throwable throwable) {
        String message;
        if (throwable != null && (message = throwable.getMessage()) != null) {
            return message;
        }
        return "Unknown reason";
    }
}

