/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import io.netty.handler.ssl.SslContext;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.SslContextFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfClientConfigurationBuilder;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.client.mdsal.api.SslContextFactoryProvider;
import org.opendaylight.netconf.shaded.sshd.client.ClientFactoryManager;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyIdentityProvider;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.tls.FixedSslHandlerFactory;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.PasswordType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.password.type.CleartextPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh.SshClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh.TcpClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.ClientIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.ClientIdentityBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.client.identity.PasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.OdlHelloMessageCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.KeyAuth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.LoginPwUnencrypted;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.key.auth.KeyBased;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.login.pw.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.login.pw.unencrypted.LoginPasswordUnencrypted;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component
public final class NetconfClientConfigurationBuilderFactoryImpl
implements NetconfClientConfigurationBuilderFactory {
    private final SslContextFactoryProvider sslContextFactoryProvider;
    private final AAAEncryptionService encryptionService;
    private final CredentialProvider credentialProvider;

    @Inject
    @Activate
    public NetconfClientConfigurationBuilderFactoryImpl(@Reference AAAEncryptionService encryptionService, @Reference CredentialProvider credentialProvider, @Reference SslContextFactoryProvider sslHandlerContextProvider) {
        this.encryptionService = Objects.requireNonNull(encryptionService);
        this.credentialProvider = Objects.requireNonNull(credentialProvider);
        this.sslContextFactoryProvider = Objects.requireNonNull(sslHandlerContextProvider);
    }

    @Override
    public NetconfClientConfigurationBuilder createClientConfigurationBuilder(NodeId nodeId, NetconfNode node) {
        NetconfClientConfigurationBuilder builder = NetconfClientConfigurationBuilder.create();
        Protocol protocol = node.getProtocol();
        if (node.requireTcpOnly().booleanValue()) {
            builder.withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TCP);
        } else if (protocol == null || protocol.getName() == Protocol.Name.SSH) {
            builder.withProtocol(NetconfClientConfiguration.NetconfClientProtocol.SSH);
            this.setSshParametersFromCredentials(builder, node.getCredentials());
        } else if (protocol.getName() == Protocol.Name.TLS) {
            SslContextFactory contextFactory = this.sslContextFactoryProvider.getSslContextFactory(protocol.getSpecification());
            SslContext sslContext = protocol.getKeyId() == null ? contextFactory.createSslContext() : contextFactory.createSslContext(protocol.getKeyId());
            builder.withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TLS).withSslHandlerFactory((SslHandlerFactory)new FixedSslHandlerFactory(sslContext));
        } else {
            throw new IllegalArgumentException("Unsupported protocol type: " + String.valueOf(protocol.getName()));
        }
        OdlHelloMessageCapabilities helloCapabilities = node.getOdlHelloMessageCapabilities();
        if (helloCapabilities != null) {
            builder.withOdlHelloCapabilities(List.copyOf(helloCapabilities.requireCapability()));
        }
        return builder.withName(nodeId.getValue()).withTcpParameters((TcpClientGrouping)new TcpClientParametersBuilder().setRemoteAddress(node.requireHost()).setRemotePort(node.requirePort()).build()).withConnectionTimeoutMillis(node.requireConnectionTimeoutMillis().toJava());
    }

    private void setSshParametersFromCredentials(NetconfClientConfigurationBuilder confBuilder, Credentials credentials) {
        SshClientParametersBuilder sshParamsBuilder = new SshClientParametersBuilder();
        if (credentials instanceof LoginPwUnencrypted) {
            LoginPwUnencrypted unencrypted = (LoginPwUnencrypted)credentials;
            LoginPasswordUnencrypted loginPassword = unencrypted.getLoginPasswordUnencrypted();
            sshParamsBuilder.setClientIdentity(NetconfClientConfigurationBuilderFactoryImpl.loginPasswordIdentity(loginPassword.getUsername(), loginPassword.getPassword()));
        } else if (credentials instanceof LoginPw) {
            byte[] plainBytes;
            LoginPw loginPw = (LoginPw)credentials;
            LoginPassword loginPassword = loginPw.getLoginPassword();
            String username = loginPassword.getUsername();
            try {
                plainBytes = this.encryptionService.decrypt(loginPassword.getPassword());
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Failed to decrypt password", e);
            }
            sshParamsBuilder.setClientIdentity(NetconfClientConfigurationBuilderFactoryImpl.loginPasswordIdentity(username, new String(plainBytes, StandardCharsets.UTF_8)));
        } else if (credentials instanceof KeyAuth) {
            KeyAuth keyAuth = (KeyAuth)credentials;
            KeyBased keyBased = keyAuth.getKeyBased();
            String keyId = keyBased.getKeyId();
            final KeyPair keyPair = this.credentialProvider.credentialForId(keyId);
            if (keyPair == null) {
                throw new IllegalArgumentException("No keypair found with keyId=" + keyId);
            }
            sshParamsBuilder.setClientIdentity(new ClientIdentityBuilder().setUsername(keyBased.getUsername()).build());
            confBuilder.withSshConfigurator(new ClientFactoryManagerConfigurator(this){

                protected void configureClientFactoryManager(ClientFactoryManager factoryManager) {
                    factoryManager.setKeyIdentityProvider(KeyIdentityProvider.wrapKeyPairs((KeyPair[])new KeyPair[]{keyPair}));
                    factoryManager.setUserAuthFactories(List.of(new UserAuthPublicKeyFactory(factoryManager.getSignatureFactories())));
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported credential type: " + String.valueOf(credentials.getClass()));
        }
        confBuilder.withSshParameters((SshClientGrouping)sshParamsBuilder.build());
    }

    private static ClientIdentity loginPasswordIdentity(String username, String password) {
        return new ClientIdentityBuilder().setUsername(Objects.requireNonNull(username, "username is undefined")).setPassword(new PasswordBuilder().setPasswordType((PasswordType)new CleartextPasswordBuilder().setCleartextPassword(Objects.requireNonNull(password, "password is undefined")).build()).build()).build();
    }
}

