/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfNodeHandler;
import org.opendaylight.netconf.topology.spi.NetconfNodeUtils;
import org.opendaylight.netconf.topology.spi.NetconfTopologyDeviceSalFacade;
import org.opendaylight.netconf.topology.spi.NetconfTopologySchemaAssembler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.NetconfNodeAugmentedOptional;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.NetconfNodeAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.netconf.node.augment.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetconfTopology {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfTopology.class);
    private final HashMap<NodeId, NetconfNodeHandler> activeConnectors = new HashMap();
    private final NetconfClientFactory clientFactory;
    private final DeviceActionFactory deviceActionFactory;
    private final SchemaResourceManager schemaManager;
    private final BaseNetconfSchemaProvider baseSchemaProvider;
    private final NetconfClientConfigurationBuilderFactory builderFactory;
    private final NetconfTimer timer;
    protected final NetconfTopologySchemaAssembler schemaAssembler;
    protected final DataBroker dataBroker;
    protected final DOMMountPointService mountPointService;
    protected final String topologyId;

    protected AbstractNetconfTopology(String topologyId, NetconfClientFactory clientFactory, NetconfTimer timer, NetconfTopologySchemaAssembler schemaAssembler, SchemaResourceManager schemaManager, DataBroker dataBroker, DOMMountPointService mountPointService, NetconfClientConfigurationBuilderFactory builderFactory, DeviceActionFactory deviceActionFactory, BaseNetconfSchemaProvider baseSchemaProvider) {
        this.topologyId = Objects.requireNonNull(topologyId);
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.timer = Objects.requireNonNull(timer);
        this.schemaAssembler = Objects.requireNonNull(schemaAssembler);
        this.schemaManager = Objects.requireNonNull(schemaManager);
        this.deviceActionFactory = deviceActionFactory;
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.mountPointService = mountPointService;
        this.builderFactory = Objects.requireNonNull(builderFactory);
        this.baseSchemaProvider = Objects.requireNonNull(baseSchemaProvider);
        WriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        wtx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Key)new TopologyKey(new TopologyId(topologyId))).build(), (DataObject)new TopologyBuilder().setTopologyId(new TopologyId(topologyId)).build());
        FluentFuture future = wtx.commit();
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to initialize topology {}", (Object)topologyId, (Object)e);
            throw new IllegalStateException(e);
        }
        LOG.debug("Topology {} initialized", (Object)topologyId);
    }

    protected void ensureNode(Node node) {
        this.lockedEnsureNode(node);
    }

    private synchronized void lockedEnsureNode(Node node) {
        RemoteDeviceId deviceId;
        NetconfNodeAugment netconfNodeAugment;
        NetconfNode netconfNode;
        NodeId nodeId = node.requireNodeId();
        NetconfNodeHandler prev = this.activeConnectors.remove(nodeId);
        if (prev != null) {
            LOG.info("RemoteDevice{{}} was already configured, disconnecting", (Object)nodeId);
            prev.close();
        }
        NetconfNode netconfNode2 = netconfNode = (netconfNodeAugment = (NetconfNodeAugment)node.augmentation(NetconfNodeAugment.class)) != null ? netconfNodeAugment.getNetconfNode() : null;
        if (netconfNode == null) {
            LOG.warn("RemoteDevice{{}} is missing NETCONF node configuration, not connecting it", (Object)nodeId);
            return;
        }
        try {
            deviceId = NetconfNodeUtils.toRemoteDeviceId(nodeId, netconfNode);
        }
        catch (NoSuchElementException e) {
            LOG.warn("RemoteDevice{{}} has invalid configuration, not connecting it", (Object)nodeId, (Object)e);
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Connecting RemoteDevice{{}}, with config {}", (Object)nodeId, (Object)AbstractNetconfTopology.hideCredentials(node));
        }
        NetconfNodeAugmentedOptional nodeOptional = (NetconfNodeAugmentedOptional)node.augmentation(NetconfNodeAugmentedOptional.class);
        RemoteDeviceHandler deviceSalFacade = this.createSalFacade(deviceId, netconfNode.getCredentials(), netconfNode.requireLockDatastore());
        NetconfNodeHandler nodeHandler = new NetconfNodeHandler(this.clientFactory, this.timer, this.baseSchemaProvider, this.schemaManager, this.schemaAssembler, this.builderFactory, this.deviceActionFactory, deviceSalFacade, deviceId, nodeId, netconfNode, nodeOptional);
        this.activeConnectors.put(nodeId, nodeHandler);
        nodeHandler.connect();
    }

    protected void deleteNode(NodeId nodeId) {
        this.lockedDeleteNode(nodeId);
    }

    private synchronized void lockedDeleteNode(NodeId nodeId) {
        String nodeName = nodeId.getValue();
        LOG.debug("Disconnecting RemoteDevice{{}}", (Object)nodeName);
        NetconfNodeHandler connectorDTO = this.activeConnectors.remove(nodeId);
        if (connectorDTO != null) {
            connectorDTO.close();
        }
    }

    protected final synchronized void deleteAllNodes() {
        this.activeConnectors.values().forEach(AbstractRegistration::close);
        this.activeConnectors.clear();
    }

    protected RemoteDeviceHandler createSalFacade(RemoteDeviceId deviceId, Credentials credentials, boolean lockDatastore) {
        return new NetconfTopologyDeviceSalFacade(deviceId, credentials, this.mountPointService, lockDatastore, this.dataBroker);
    }

    @VisibleForTesting
    static final String hideCredentials(Node nodeConfiguration) {
        NetconfNode netconfNode;
        String nodeConfigurationString = nodeConfiguration.toString();
        NetconfNodeAugment netconfNodeAugmentation = (NetconfNodeAugment)nodeConfiguration.augmentation(NetconfNodeAugment.class);
        NetconfNode netconfNode2 = netconfNode = netconfNodeAugmentation != null ? netconfNodeAugmentation.getNetconfNode() : null;
        if (netconfNode != null && netconfNode.getCredentials() != null) {
            String nodeCredentials = netconfNode.getCredentials().toString();
            return nodeConfigurationString.replace(nodeCredentials, "***");
        }
        return nodeConfigurationString;
    }
}

