/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.schemacache;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.spi.AbstractSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.spi.source.DelegatedYangTextSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaSourceCache<T extends SourceRepresentation>
extends AbstractSchemaSourceCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSourceCache.class);
    private final Class<T> representation;
    private Map<SourceIdentifier, YangModuleInfo> cachedSchemas;

    public SchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation, Set<YangModuleInfo> moduleList) {
        super(consumer, representation, PotentialSchemaSource.Costs.LOCAL_IO);
        this.representation = representation;
        this.initializeCachedSchemas(moduleList);
    }

    private void initializeCachedSchemas(Set<YangModuleInfo> moduleList) {
        HashSet<YangModuleInfo> allModulesInfo = new HashSet<YangModuleInfo>(moduleList);
        allModulesInfo.addAll(moduleList.stream().flatMap(yangModuleInfo -> SchemaSourceCache.collectYangModuleInfoDependencies(yangModuleInfo, moduleList).stream()).collect(Collectors.toSet()));
        this.cachedSchemas = allModulesInfo.stream().map(yangModuleInfo -> {
            QName name = yangModuleInfo.getName();
            SourceIdentifier revisionSourceIdentifier = new SourceIdentifier(name.getLocalName(), (String)name.getRevision().map(Revision::toString).orElse(null));
            return new AbstractMap.SimpleEntry<SourceIdentifier, YangModuleInfo>(revisionSourceIdentifier, (YangModuleInfo)yangModuleInfo);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.cachedSchemas.keySet().forEach(x$0 -> this.register((SourceIdentifier)x$0));
    }

    private static Set<YangModuleInfo> collectYangModuleInfoDependencies(YangModuleInfo yangModuleInfo, Set<YangModuleInfo> collectedModulesInfo) {
        HashSet<YangModuleInfo> allDependencies = new HashSet<YangModuleInfo>(collectedModulesInfo);
        Set directDependencies = yangModuleInfo.getImportedModules().stream().filter(importedYangModuleInfo -> !collectedModulesInfo.contains(importedYangModuleInfo)).collect(Collectors.toSet());
        allDependencies.addAll(directDependencies);
        Set indirectDependencies = directDependencies.stream().flatMap(importedYangModuleInfo -> SchemaSourceCache.collectYangModuleInfoDependencies(importedYangModuleInfo, allDependencies).stream()).collect(Collectors.toSet());
        allDependencies.addAll(indirectDependencies);
        return allDependencies;
    }

    public synchronized ListenableFuture<? extends T> getSource(SourceIdentifier sourceIdentifier) {
        YangModuleInfo yangModuleInfo = this.cachedSchemas.get(sourceIdentifier);
        if (yangModuleInfo != null) {
            DelegatedYangTextSource yangTextSchemaSource = new DelegatedYangTextSource(sourceIdentifier, yangModuleInfo.getYangTextCharSource());
            return Futures.immediateFuture((Object)((SourceRepresentation)this.representation.cast(yangTextSchemaSource)));
        }
        LOG.debug("Source {} not found in cache", (Object)sourceIdentifier);
        return Futures.immediateFailedFuture((Throwable)new MissingSchemaSourceException(sourceIdentifier, "Source not found"));
    }

    protected synchronized void offer(T source) {
        LOG.trace("Source {} offered to cache", (Object)source.sourceId());
    }
}

