/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.rpchandler;

import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.api.operations.HandlingPriority;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.netconf.test.tool.rpchandler.RpcHandler;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Document;

class SettableRpc
implements NetconfOperation {
    private final RpcHandler rpcHandler;

    SettableRpc(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
    }

    public HandlingPriority canHandle(Document message) {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY.increasePriority(1000);
    }

    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        XmlElement requestElement = XmlElement.fromDomDocument((Document)requestMessage);
        XmlElement rpcElement = requestElement.getOnlyChildElement();
        String msgId = requestElement.getAttribute("message-id");
        Optional<Document> response = this.rpcHandler.getResponse(rpcElement);
        if (response.isPresent()) {
            Document document = response.orElseThrow();
            SettableRpc.checkForError(document);
            document.getDocumentElement().setAttribute("message-id", msgId);
            return document;
        }
        if (subsequentOperation != null) {
            return subsequentOperation.execute(requestMessage);
        }
        throw new DocumentedException("Mapping not found " + XmlUtil.toString((Document)requestMessage), ErrorType.APPLICATION, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
    }

    private static void checkForError(Document document) throws DocumentedException {
        XmlElement rpcReply = XmlElement.fromDomDocument((Document)document);
        if (rpcReply.getOnlyChildElementOptionally("rpc-error").isPresent()) {
            throw DocumentedException.fromXMLDocument((Document)document);
        }
    }
}

