/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.rpc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.api.operations.AbstractLastNetconfOperation;
import org.opendaylight.netconf.test.tool.rpc.DataList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SimulatedGetConfig
extends AbstractLastNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SimulatedGetConfig.class);
    private final DataList storage;

    public SimulatedGetConfig(SessionIdType sessionId, DataList storage, Optional<File> initialConfigXMLFile) {
        super(sessionId);
        if (initialConfigXMLFile.isPresent()) {
            File file = initialConfigXMLFile.orElseThrow();
            LOG.info("File is present: {}", (Object)file.getName());
            this.storage = SimulatedGetConfig.loadInitialConfigXMLFile(file);
        } else {
            this.storage = storage;
        }
    }

    private static DataList loadInitialConfigXMLFile(File file) {
        LOG.info("Loading initial config xml file: {}", (Object)file.getName());
        DataList configData = new DataList();
        try {
            Element element = XmlUtil.readXmlToElement((File)file);
            XmlElement xmlElement = XmlElement.fromDomElement((Element)element);
            List xmlElementList = xmlElement.getChildElements();
            configData.setConfigList(xmlElementList);
        }
        catch (IOException e) {
            LOG.info("IO exception loading xml file: {} ", (Object)e.getMessage());
        }
        catch (SAXException e) {
            LOG.info("SAXException {}", (Object)e.getMessage());
        }
        return configData;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) {
        Element element = document.createElement("data");
        for (XmlElement e : this.storage.getConfigList()) {
            Element domElement = e.getDomElement();
            element.appendChild(element.getOwnerDocument().importNode(domElement, true));
        }
        return element;
    }

    protected String getOperationName() {
        return "get-config";
    }
}

