/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.rpc;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.operations.AbstractLastNetconfOperation;
import org.opendaylight.netconf.test.tool.rpc.DataList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimulatedEditConfig
extends AbstractLastNetconfOperation {
    private static final String DELETE_EDIT_CONFIG = "delete";
    private static final String OPERATION = "operation";
    private static final String REMOVE_EDIT_CONFIG = "remove";
    private final DataList storage;

    public SimulatedEditConfig(SessionIdType sessionId, DataList storage) {
        super(sessionId);
        this.storage = storage;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        XmlElement configElementData = operationElement.getOnlyChildElement("config");
        this.containsDelete(configElementData);
        if (this.containsDelete(configElementData)) {
            this.storage.resetConfigList();
        } else {
            this.storage.setConfigList(configElementData.getChildElements());
        }
        return document.createElement("ok");
    }

    protected String getOperationName() {
        return "edit-config";
    }

    private boolean containsDelete(XmlElement element) {
        for (Attr o : element.getAttributes().values()) {
            if (!o.getLocalName().equals(OPERATION) || !o.getValue().equals(DELETE_EDIT_CONFIG) && !o.getValue().equals(REMOVE_EDIT_CONFIG)) continue;
            return true;
        }
        for (XmlElement xmlElement : element.getChildElements()) {
            if (!this.containsDelete(xmlElement)) continue;
            return true;
        }
        return false;
    }
}

