/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.api.operations.AbstractLastNetconfOperation;
import org.opendaylight.netconf.server.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SimulatedCreateSubscription
extends AbstractLastNetconfOperation
implements DefaultNetconfOperation {
    private final Map<Notification, NetconfMessage> notifications;
    private NetconfServerSession session;
    private ScheduledExecutorService scheduledExecutorService;

    public SimulatedCreateSubscription(SessionIdType sessionId, Optional<File> notificationsFile) {
        super(sessionId);
        Optional<Object> notifs;
        if (notificationsFile.isPresent()) {
            notifs = Optional.of(SimulatedCreateSubscription.loadNotifications(notificationsFile.orElseThrow()));
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        } else {
            notifs = Optional.empty();
        }
        if (notifs.isPresent()) {
            List<Notification> toCopy = ((Notifications)notifs.orElseThrow()).getNotificationList();
            HashMap preparedMessages = Maps.newHashMapWithExpectedSize((int)toCopy.size());
            for (Notification notification : toCopy) {
                NetconfMessage parsedNotification = SimulatedCreateSubscription.parseNetconfNotification(notification.getContent());
                preparedMessages.put(notification, parsedNotification);
            }
            this.notifications = preparedMessages;
        } else {
            this.notifications = Map.of();
        }
    }

    private static Notifications loadNotifications(File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Notifications.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (Notifications)jaxbUnmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Canot parse file " + String.valueOf(file) + " as a notifications file", e);
        }
    }

    protected String getOperationName() {
        return "create-subscription";
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:notification:1.0";
    }

    protected Element handleWithNoSubsequentOperations(Document document, org.opendaylight.netconf.api.xml.XmlElement operationElement) {
        long delayAggregator = 0L;
        for (Map.Entry<Notification, NetconfMessage> notification : this.notifications.entrySet()) {
            int i = 0;
            while ((long)i <= notification.getKey().getTimes()) {
                this.scheduledExecutorService.schedule(() -> {
                    Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session is not set, cannot process notifications");
                    this.session.sendMessage((NetconfMessage)notification.getValue());
                }, delayAggregator += notification.getKey().getDelayInSeconds(), TimeUnit.SECONDS);
                ++i;
            }
        }
        return document.createElement("ok");
    }

    private static NetconfMessage parseNetconfNotification(String content) {
        int endEventTime;
        int startEventTime = content.indexOf("<eventTime>") + "<eventTime>".length();
        String eventTime = content.substring(startEventTime, endEventTime = content.indexOf("</eventTime>"));
        if (eventTime.equals("XXXX")) {
            content = content.replace(eventTime, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(new Date()));
        }
        try {
            return new NetconfMessage(XmlUtil.readXmlToDocument((String)content));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("Cannot parse notifications", e);
        }
    }

    public void setNetconfSession(NetconfServerSession newSession) {
        this.session = newSession;
    }

    @XmlRootElement(name="notifications")
    public static final class Notifications {
        @XmlElement(nillable=false, name="notification", required=true)
        private List<Notification> notificationList;

        public List<Notification> getNotificationList() {
            return this.notificationList;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Notifications{");
            sb.append("notificationList=").append(this.notificationList);
            sb.append('}');
            return sb.toString();
        }
    }

    public static final class Notification {
        @XmlElement(nillable=false, name="delay")
        private long delayInSeconds;
        @XmlElement(nillable=false, name="times")
        private long times;
        @XmlElement(nillable=false, name="content", required=true)
        private String content;

        public long getDelayInSeconds() {
            return this.delayInSeconds;
        }

        public long getTimes() {
            return this.times;
        }

        public String getContent() {
            return this.content;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Notification{");
            sb.append("delayInSeconds=").append(this.delayInSeconds);
            sb.append(", times=").append(this.times);
            sb.append(", content='").append(this.content).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

