/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.operations;

import java.util.Set;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.test.tool.operations.DefaultOperationsCreator;
import org.opendaylight.netconf.test.tool.operations.OperationsCreator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.Registration;

public class OperationsProvider
implements NetconfOperationServiceFactory {
    private final Set<Capability> caps;
    private final OperationsCreator operationsCreator;

    public OperationsProvider(Set<Capability> caps) {
        this(caps, new DefaultOperationsCreator());
    }

    public OperationsProvider(Set<Capability> caps, OperationsCreator operationsCreator) {
        this.caps = caps;
        this.operationsCreator = operationsCreator;
    }

    public Set<Capability> getCapabilities() {
        return this.caps;
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(this.caps, Set.of());
        return () -> {};
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return this.operationsCreator.getNetconfOperationService(this.caps, sessionId);
    }
}

