/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.operations;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.test.tool.operations.OperationsCreator;
import org.opendaylight.netconf.test.tool.rpc.DataList;
import org.opendaylight.netconf.test.tool.rpc.SimulatedCommit;
import org.opendaylight.netconf.test.tool.rpc.SimulatedCreateSubscription;
import org.opendaylight.netconf.test.tool.rpc.SimulatedDiscardChanges;
import org.opendaylight.netconf.test.tool.rpc.SimulatedEditConfig;
import org.opendaylight.netconf.test.tool.rpc.SimulatedGet;
import org.opendaylight.netconf.test.tool.rpc.SimulatedGetConfig;
import org.opendaylight.netconf.test.tool.rpc.SimulatedLock;
import org.opendaylight.netconf.test.tool.rpc.SimulatedUnLock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;

public final class DefaultOperationsCreator
implements OperationsCreator {
    @Override
    public NetconfOperationService getNetconfOperationService(Set<Capability> caps, SessionIdType sessionId) {
        return new SimulatedOperationService(sessionId);
    }

    static class SimulatedOperationService
    implements NetconfOperationService {
        private final SessionIdType currentSessionId;

        SimulatedOperationService(SessionIdType currentSessionId) {
            this.currentSessionId = Objects.requireNonNull(currentSessionId);
        }

        public Set<NetconfOperation> getNetconfOperations() {
            DataList storage = new DataList();
            SimulatedGet sGet = new SimulatedGet(this.currentSessionId, storage);
            SimulatedEditConfig sEditConfig = new SimulatedEditConfig(this.currentSessionId, storage);
            SimulatedGetConfig sGetConfig = new SimulatedGetConfig(this.currentSessionId, storage, Optional.empty());
            SimulatedCommit sCommit = new SimulatedCommit(this.currentSessionId);
            SimulatedLock sLock = new SimulatedLock(this.currentSessionId);
            SimulatedUnLock sUnlock = new SimulatedUnLock(this.currentSessionId);
            SimulatedCreateSubscription sCreateSubs = new SimulatedCreateSubscription(this.currentSessionId, Optional.empty());
            SimulatedDiscardChanges sDiscardChanges = new SimulatedDiscardChanges(this.currentSessionId);
            return Set.of(sGet, sGetConfig, sEditConfig, sCommit, sLock, sUnlock, sCreateSubs, sDiscardChanges);
        }

        public void close() {
        }
    }
}

