/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.monitoring;

import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.test.tool.monitoring.MonitoringSchema;
import org.opendaylight.netconf.test.tool.monitoring.MonitoringSession;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;

@XmlRootElement(name="netconf-state")
public final class NetconfState {
    private Schemas schemas;
    private Sessions sessions;

    public NetconfState(NetconfMonitoringService monitoringService) {
        this.sessions = monitoringService.getSessions();
        this.schemas = monitoringService.getSchemas();
    }

    public NetconfState() {
    }

    @XmlElementWrapper(name="schemas")
    @XmlElement(name="schema")
    public Collection<MonitoringSchema> getSchemas() {
        return Collections2.transform(this.schemas.nonnullSchema().values(), MonitoringSchema::new);
    }

    @XmlElementWrapper(name="sessions")
    @XmlElement(name="session")
    public Collection<MonitoringSession> getSessions() {
        return Collections2.transform(this.sessions.nonnullSession().values(), MonitoringSession::new);
    }
}

