/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.monitoring;

import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.test.tool.monitoring.NetconfMonitoringOperationService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.Registration;

public class NetconfMonitoringOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private final @NonNull NetconfMonitoringService monitor;

    public NetconfMonitoringOperationServiceFactory(NetconfMonitoringService monitor) {
        this.monitor = Objects.requireNonNull(monitor);
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return new NetconfMonitoringOperationService(sessionId, this.monitor);
    }

    public Set<Capability> getCapabilities() {
        return Set.of();
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        return () -> {};
    }

    @Override
    public void close() {
    }
}

