/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.monitoring;

import com.google.common.base.Joiner;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.monitoring.rev220718.Session1;
import org.opendaylight.yangtools.yang.common.QName;

final class MonitoringSession {
    @XmlTransient
    private Session managementSession;

    MonitoringSession(Session managementSession) {
        this.managementSession = managementSession;
    }

    MonitoringSession() {
    }

    public void setManagementSession(Session managementSession) {
        this.managementSession = managementSession;
    }

    @XmlElement(name="session-id")
    public long getId() {
        return this.managementSession.getSessionId().longValue();
    }

    @XmlElement(name="source-host")
    public String getSourceHost() {
        IpAddress ipAddress = this.managementSession.getSourceHost().getIpAddress();
        if (ipAddress.getIpv4Address() != null) {
            return ipAddress.getIpv4Address().getValue();
        }
        return ipAddress.getIpv6Address().getValue();
    }

    @XmlElement(name="login-time")
    public String getLoginTime() {
        return this.managementSession.getLoginTime().getValue();
    }

    @XmlElement(name="in-bad-rpcs")
    public Long getInBadRpcs() {
        return this.managementSession.getInBadRpcs().getValue().longValue();
    }

    @XmlElement(name="in-rpcs")
    public Long getInRpcs() {
        return this.managementSession.getInRpcs().getValue().longValue();
    }

    @XmlElement(name="out-notifications")
    public Long getOutNotifications() {
        return this.managementSession.getOutNotifications().getValue().longValue();
    }

    @XmlElement(name="out-rpc-errors")
    public Long getOutRpcErrors() {
        return this.managementSession.getOutRpcErrors().getValue().longValue();
    }

    @XmlElement(name="transport")
    public String getTransport() {
        try {
            QName qualifiedName = (QName)this.managementSession.getTransport().implementedInterface().getField("QNAME").get(null);
            if (qualifiedName.getNamespace().toString().equals("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring-extension")) {
                return Joiner.on((char)':').join((Object)"ncme", (Object)qualifiedName.getLocalName(), new Object[0]);
            }
            return qualifiedName.getLocalName();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("Unknown transport type " + String.valueOf(this.managementSession.getTransport()), e);
        }
    }

    @XmlElement(name="session-identifier", namespace="urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring-extension")
    public String getSessionType() {
        return ((Session1)this.managementSession.augmentation(Session1.class)).getSessionIdentifier();
    }

    @XmlElement(name="username")
    public String getUsername() {
        return this.managementSession.getUsername();
    }
}

